/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.tenqube.visual_third.OnResultListener;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.core.VisualApi;
import com.tenqube.visual_third.core.VisualWebActivity;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private PrefManager prefManager;
    private AppCompatActivity activity;
    private VisualApi api;
    private ParserService parserService;

    public VisualServiceImpl(@NonNull AppCompatActivity activity) throws ParameterException {
        if (activity == null) {
            throw new ParameterException("activity is null");
        }
        this.activity = activity;
        this.prefManager = PrefManager.getInstance((Context)activity);
        this.api = VisualApi.getInstance((Context)activity);
        this.parserService = ParserService.getInstance((Context)activity);
    }

    @Override
    public void setQualifier(String qualifier) throws ParameterException {
        if (!"dev".equals(qualifier) && !"prod".equals(qualifier)) {
            throw new ParameterException("check qualifier value (dev, prod)");
        }
        this.prefManager.saveStringValue("TENQUBE_LAYER", qualifier);
    }

    @Override
    public void signUp(@NonNull String custId, @NonNull OnResultListener onResultListener) throws ParameterException, AuthException {
        Validator.isCustId(custId);
        if (!TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("already joined.");
        }
        LogUtil.LOGI((String)TAG, (String)"\uac00\uc785", (boolean)ParserService.mIsDebug);
        this.api.signUp(new SignUpRequest(custId), onResultListener);
    }

    @Override
    public void startVisual() throws AuthException, SecurityException {
        if (TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("UID is empty");
        }
        if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false) && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_MMS") != 0) {
            throw new SecurityException("Please grant permissions (Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS, Manifest.permission.RECEIVE_MMS)");
        }
        LogUtil.LOGI((String)TAG, (String)"\uc6f9 \uac00\uacc4\ubd80 \ud638\ucd9c", (boolean)ParserService.mIsDebug);
        VisualWebActivity.startActivity((Context)this.activity, "");
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        LogUtil.LOGI((String)TAG, (String)"setDebugMode", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isDebug);
        }
    }

    @Override
    public void initSDK() {
        LogUtil.LOGI((String)TAG, (String)"initSDK", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    private boolean isActive() {
        return this.activity != null && !this.activity.isFinishing();
    }
}

