package com.tenqube.visual_third.core;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.webkit.WebView;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class VisualWebActivity extends AppCompatActivity {

    public static final String ARG_PATH = "ARG_PATH";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();

    public static final int FINISH = 0;
    public static final int PROGRESS = 1;
    public static final int SHOW_PROGRESS_BAR = 2;
    public static final int ERROR = 3;
    private ProgressDialogFragment progressDialog;

    private PrefManager prefManager;

    public static void startActivity(Context context, String path) throws AuthException {
        if(TextUtils.isEmpty(PrefManager.getInstance(context).loadStringValue(PrefManager.UID, "")))
            throw new AuthException("Need to sign up");

        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        context.startActivity(intent);
    }

    private String path;
    private WebView webview;
    private BulkLoader bulkLoader;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            prefManager = PrefManager.getInstance(getApplicationContext());
            path = getIntent().getStringExtra(ARG_PATH);

            setContentView(R.layout.activity_visual_web);

            webview = findViewById(R.id.visual_web_view);
            webview.addJavascriptInterface(new WebAppInterface(this, webview, new BottomDialog(this)), "visual");
            webview.getSettings().setJavaScriptEnabled(true);

            if(!prefManager.isEnabled(PrefManager.BULK_EXECUTED, false)) { // 벌크 파싱 진행
                LOGI(TAG, "벌크 파싱 진행", mIsDebug);
                startBulkParsing();
            } else { // 웹 가계부 호출
                webview.loadUrl(prefManager.loadStringValue(PrefManager.WEB_URL, "") + path);
                // webview.loadUrl("file:///android_asset/index.html");
            }
        } catch (Exception e) {
            finish();
        }

    }

    private Handler handler = new Handler(new Handler.Callback() { // 핸들러로 전달받은 값 progress 값 세팅해주기
        @Override
        public boolean handleMessage(final Message msg) {

            switch (msg.what) {
                case PROGRESS:
                    if(progressDialog != null && progressDialog.isAdded()) {
                        Bundle bundle = msg.getData();
                        if(bundle != null) {
                            progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                        }
                    }
                    break;

                case SHOW_PROGRESS_BAR:

                    if(progressDialog == null) {
                        progressDialog = ProgressDialogFragment.newInstance();
                        progressDialog.setCancelable(false);
                    }

                    try {
                        if(!progressDialog.isAdded()) {
                            FragmentManager fragmentManager = getSupportFragmentManager();
                            progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                        }
                    } catch (ClassCastException e) {
                        e.printStackTrace();
                    }

                    break;
                default:
                    prefManager.saveBoolean(PrefManager.BULK_EXECUTED, true);
                    if(progressDialog != null && progressDialog.isAdded()) progressDialog.dismiss();
                    if(webview != null) webview.loadUrl(PrefManager.getInstance(getApplicationContext()).loadStringValue(PrefManager.WEB_URL, "" + path));
                        // webview.loadUrl("file:///android_asset/index.html");
                    break;
            }

            return false;
        }
    });

    /**
     * 1. 퍼미션 체크
     * 2. 프로그레스 다이얼로그 show
     * 3. 지난 6개월 문자 파싱 시작
     */
    private void startBulkParsing() {

        new Thread(new Runnable() {
            @Override
            public void run() {
                try {

                    LOGI(TAG, "startBulkParsing start", mIsDebug);
                    bulkLoader = new BulkLoader(VisualWebActivity.this, handler, new BulkLoader.OnSmsLoadFinished() {
                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if(handler != null) handler.sendEmptyMessage(FINISH);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    // 2. 프로그레스 다이얼로그 show
                    LOGI(TAG, "2. 프로그레스 다이얼로그 show", mIsDebug);
                    handler.sendEmptyMessage(SHOW_PROGRESS_BAR);

                    // 3. 지난 6개월 문자 파싱 시작
                    LOGI(TAG, "3. 지난 6개월 문자 파싱 시작", mIsDebug);
                    bulkLoader.doParsing();

                } catch (Exception e) {
                    handler.sendEmptyMessage(ERROR);
                }

            }
        }).start();

    }

}
