package com.tenqube.visual_third.model.api;


import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.ArrayList;

public class SearchCompanyResponse implements Serializable {

    private ArrayList<TranCompany> results;

    public SearchCompanyResponse(ArrayList<TranCompany> results) {
        this.results = results;
    }

    public ArrayList<TranCompany> getResults() {
        return results;
    }

    public static class TranCompany {

        @SerializedName("id")
        private String identifier;

        @SerializedName("classCode")
        private String classCode;

        @SerializedName("company")
        private Company company;

        @SerializedName("category")
        private Category category;

        @SerializedName("keyword")
        private Keyword keyword;


        public String getIdentifier() {
            return identifier;
        }

        public String getClassCode() {
            return classCode;
        }

        public Company getCompany() {
            return company;
        }

        public Category getCategory() {
            return category;
        }

        public Keyword getKeyword() {
            return keyword;
        }
    }



    public static class Company {
        private int id;
        private String name;
        private String address;

        public int getId() {
            return id;
        }

        public String getName() {
            return name;
        }

        public String getAddress() {
            return address;
        }
    }

    public static class Category {
        private String code;

        public String getCode() {
            return code;
        }
    }

    public static class Keyword {
        private String ori;
        private String search;

        public String getOri() {
            return ori;
        }

        public String getSearch() {
            return search;
        }
    }
}
