package com.tenqube.visual_third.core;

import android.support.annotation.NonNull;

import com.tenqube.visual_third.manager.PrefManager;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class AddSearchHeaderInterceptor implements Interceptor {

    private PrefManager prefManager;
    AddSearchHeaderInterceptor(PrefManager prefManager) {
        this.prefManager = prefManager;
    }

    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Request mainRequest = chain.request();
        Request.Builder builder = mainRequest.newBuilder();
        builder.addHeader("x-api-key", prefManager.loadStringValue(PrefManager.SEARCH_API_KEY, ""));
        builder.addHeader("Content-Type", "application/json");
        return chain.proceed(builder.build());
    }
}
