package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.core.WebAppInterface;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;

public class VisualWebActivity extends Activity {

    public static final String ARG_PATH = "ARG_PATH";

    public static void startActivity(Context context, String path) throws AuthException {
        if(TextUtils.isEmpty(PrefManager.getInstance(context).loadStringValue(PrefManager.UID, "")))
            throw new AuthException("Need to sign up");

        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        context.startActivity(intent);

    }

    private String path;
    private WebView webview;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            path = getIntent().getStringExtra(ARG_PATH);

            setContentView(R.layout.activity_visual_web);

            webview = findViewById(R.id.visual_web_view);
            webview.addJavascriptInterface(new WebAppInterface(this, webview, new BottomDialog(this)), "visual");
            webview.getSettings().setJavaScriptEnabled(true);

            webview.setWebChromeClient(new WebChromeClient() {
                public void onProgressChanged(WebView view, int progress) {
                }
            });

            webview.setWebViewClient(new WebViewClient() {
                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                }
            });

            webview.loadUrl(PrefManager.getInstance(getApplicationContext()).loadStringValue(PrefManager.WEB_URL, "" + path));

            // webview.loadUrl("file:///android_asset/index.html");

        } catch (Exception e) {
            finish();
        }

    }

}
