/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db;

import android.text.TextUtils;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

public class QueryGenerator {
    private static final String COMMON_CONDITION = "isDeleted = 0 ";
    public static final String SELECT = " SELECT  ";
    public static final String FROM = " FROM  ";
    public static final String WHERE = " WHERE  ";
    public static final String LIMIT = " LIMIT  ";
    public static final String JOIN = " JOIN  ";
    public static final String ON = " ON  ";
    public static final String AND = " AND  ";
    public static final String IN = " IN  ";
    public static final String GROUP_BY = " GROUP BY  ";
    public static final String ORDER_BY = " ORDER BY  ";

    public static String allTransactions() {
        return " SELECT   *  FROM   TRANSACTIONS AS tran  JOIN   CARDS AS card  ON   tran.cardId= card.cId JOIN   USER_CATEGORIES  AS userCate  ON   tran.userCategoryId= userCate.ucId JOIN   CATEGORIES  AS ca  ON   tran.categoryCode= ca.cateCode";
    }

    public static String deletedTranIds() {
        return " SELECT  tranId FROM   TRANSACTIONS WHERE  isDeleted = 1  AND  isSynced = 1";
    }

    public static String applyAllTran(String keyword) {
        return " SELECT   *  FROM   TRANSACTIONS WHERE  isUpdateAll = 1 AND keyword = '" + keyword + "'" + " AND " + COMMON_CONDITION + LIMIT + " 1 ";
    }

    public static String tranId(String identifier) {
        String whereCondition = "identifier=" + identifier + " AND " + COMMON_CONDITION;
        return " SELECT  tranId FROM   TRANSACTIONS WHERE  " + whereCondition;
    }

    public static String sum(String fromAt, String toAt, int groupBy) {
        String whereCondition = "dwType= 1  AND  spentDate >= " + fromAt + "" + AND + "spentDate" + " < " + toAt + "" + AND + " card." + "isCardExcept" + "= 0" + AND + " userCate." + "isCateExcept" + "= 0" + AND + COMMON_CONDITION;
        String groupColumn = "";
        ArrayList<String> groupTitles = new ArrayList<String>();
        switch (groupBy) {
            case 3: {
                groupColumn = " tran.cardId";
                groupTitles.add(" card.cardName");
                groupTitles.add(" card.cardType");
                break;
            }
            case 4: {
                groupColumn = " tran.userCategoryId";
                groupTitles.add(" ca.largeName");
                break;
            }
            case 5: {
                groupColumn = " tran.keyword";
                groupTitles.add(" tran.keyword");
            }
        }
        String groupTitle = groupTitles.size() == 0 ? "" : "," + TextUtils.join((CharSequence)",", groupTitles);
        String query = " SELECT   SUM(spentMoney) " + groupTitle + FROM + " TRANSACTIONS" + " AS tran " + JOIN + " CARDS" + " AS card " + ON + " tran." + "cardId" + "=" + " card." + "cId" + JOIN + " USER_CATEGORIES " + " AS userCate " + ON + " tran." + "userCategoryId" + "=" + " userCate." + "ucId" + JOIN + " CATEGORIES " + " AS ca " + ON + " tran." + "categoryCode" + "=" + " ca." + "cateCode" + WHERE + whereCondition;
        if (!TextUtils.isEmpty((CharSequence)groupColumn)) {
            query = query + GROUP_BY + groupColumn;
        }
        return query;
    }

    public static String sum(String fromAt, String toAt) {
        String whereCondition = "dwType= 1  AND  spentDate>='" + fromAt + "'" + AND + "spentDate" + "<'" + toAt + "'" + AND + " card." + "isCardExcept" + "= 0" + AND + " userCate." + "isCateExcept" + "= 0" + AND + COMMON_CONDITION;
        return " SELECT   SUM(spentMoney) FROM   TRANSACTIONS AS tran  JOIN   CARDS AS card  ON   tran.cardId= card.cId JOIN   USER_CATEGORIES  AS userCate  ON   tran.userCategoryId= userCate.ucId WHERE  " + whereCondition;
    }

    public static String transaction() {
        return " SELECT   *  FROM   TRANSACTIONS WHERE  isDeleted = 0 ";
    }

    public static String failedSearchTransaction() {
        String whereCondition = "shouldRetrySearch= 1 AND  isUserUpdate = 0";
        return " SELECT   *  FROM   TRANSACTIONS AS tran  JOIN   CARDS AS card  ON   tran.cardId= card.cId JOIN   USER_CATEGORIES  AS userCate  ON   tran.userCategoryId= userCate.ucId JOIN   CATEGORIES  AS ca  ON   tran.categoryCode= ca.cateCode WHERE  " + whereCondition;
    }

    public static String joinedTransaction(TransactionByIdsRequest transactionRequest) {
        String whereCondition = "tranId IN (" + TextUtils.join((CharSequence)",", transactionRequest.getTranIds()) + ")" + AND + COMMON_CONDITION;
        return " SELECT   *  FROM   TRANSACTIONS AS tran  JOIN   CARDS AS card  ON   tran.cardId= card.cId JOIN   USER_CATEGORIES  AS userCate  ON   tran.userCategoryId= userCate.ucId JOIN   CATEGORIES  AS ca  ON   tran.categoryCode= ca.cateCode WHERE  " + whereCondition;
    }

    public static String joinedTransaction(TransactionRequest transactionRequest) {
        String[] dates = Utils.getDateRange(transactionRequest.getYear(), transactionRequest.getMonth(), transactionRequest.getBefore());
        String whereCondition = "spentDate>= " + dates[0] + AND + "spentDate" + " < " + dates[1];
        if (transactionRequest.getDwType() != -1) {
            whereCondition = whereCondition + " AND  dwType = " + transactionRequest.getDwType();
        }
        if (transactionRequest.getExceptType() != -1) {
            whereCondition = whereCondition + " AND   userCate.isCateExcept= " + transactionRequest.getExceptType();
        }
        whereCondition = whereCondition + " AND  isDeleted = 0 ";
        return " SELECT   *  FROM   TRANSACTIONS AS tran  JOIN   CARDS AS card  ON   tran.cardId= card.cId JOIN   USER_CATEGORIES  AS userCate  ON   tran.userCategoryId= userCate.ucId JOIN   CATEGORIES  AS ca  ON   tran.categoryCode= ca.cateCode WHERE  " + whereCondition;
    }

    public static String joinedTransaction(int tranId) {
        String whereCondition = "tranId = " + tranId;
        whereCondition = whereCondition + " AND  isDeleted = 0 ";
        return " SELECT   *  FROM   TRANSACTIONS AS tran  JOIN   CARDS AS card  ON   tran.cardId= card.cId JOIN   USER_CATEGORIES  AS userCate  ON   tran.userCategoryId= userCate.ucId JOIN   CATEGORIES  AS ca  ON   tran.categoryCode= ca.cateCode WHERE  " + whereCondition;
    }

    public static String notSyncedTransactions() {
        String whereCondition = "isSynced= 0  AND  companyId != 0 ";
        return " SELECT   *  FROM   TRANSACTIONS AS tran  JOIN   CARDS AS card  ON   tran.cardId= card.cId JOIN   USER_CATEGORIES  AS userCate  ON   tran.userCategoryId= userCate.ucId JOIN   CATEGORIES  AS ca  ON   tran.categoryCode= ca.cateCode WHERE  " + whereCondition + LIMIT + " 30 ";
    }

    public static String card() {
        return " SELECT   *  FROM   CARDS";
    }

    public static String cardId(String cardName, int cardType, int cardSubType) {
        String whereCondition = "cardName = '" + cardName + "' " + AND + "cardType" + " = " + cardType + AND + "cardSubType" + " = " + cardSubType;
        return " SELECT  cId FROM   CARDS WHERE  " + whereCondition;
    }

    public static String category() {
        return " SELECT   *  FROM   CATEGORIES ";
    }

    public static String categoryByMedium() {
        return " SELECT   *  FROM   CATEGORIES  GROUP BY   substr( cateCode, 1, 4)";
    }

    public static String category(String categoryCode) {
        String whereCondition = "cateCode=" + categoryCode;
        return " SELECT   *  FROM   CATEGORIES  WHERE  " + whereCondition;
    }

    public static String userCategory() {
        return " SELECT   *  FROM   USER_CATEGORIES ";
    }

    public static String userCategory(String repCode) {
        String whereCondition = "repCode=" + repCode;
        return " SELECT  ucId FROM   USER_CATEGORIES  WHERE  " + whereCondition;
    }

    public static String contents() {
        return " SELECT   *  FROM   CONTENTS";
    }

    public static String conditions() {
        return " SELECT   *  FROM   CONDITIONS";
    }

    public static String currency(String from, String to) {
        String whereCondition = "currency_from='" + from + "'" + AND + "currency_to" + "='" + to + "'";
        return " SELECT  * FROM   CURRENCY  WHERE  " + whereCondition;
    }

    public static String isActive(String name) {
        String whereCondition = "noti_name like '%" + name + "%'";
        return " SELECT  noti_enable FROM   NOTIFICATIONS  WHERE  " + whereCondition;
    }

    public static String notification() {
        return " SELECT  * FROM   NOTIFICATIONS ";
    }

    public static String notification(String name) {
        String whereCondition = "noti_name like '%" + name + "%'";
        return " SELECT  * FROM   NOTIFICATIONS  WHERE  " + whereCondition;
    }

    public static String notification(boolean enabled) {
        int value = enabled ? 1 : 0;
        String whereCondition = "noti_enable=" + value;
        return " SELECT  * FROM   NOTIFICATIONS  WHERE  " + whereCondition;
    }

    public static String advertisement(int id2) {
        String whereCondition = "adId=" + id2;
        return " SELECT   *  FROM   ADVERTISEMENTS  WHERE  " + whereCondition;
    }

    public static String advertisement() {
        String whereCondition = "adId!=0";
        return " SELECT   *  FROM   ADVERTISEMENTS  WHERE  " + whereCondition + ORDER_BY + "adPriority" + " DESC ";
    }

    public static String notificationApp() {
        return " SELECT  * FROM   NOTIFICATION_APPS  ORDER BY  priority DESC ";
    }
}

