/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;

public class TransactionPopupActivity
extends Activity {
    public static final String ARG_TRANSACTION = "ARG_TRANSACTION";
    public static final String ACTION_TRAN_POPUP = "tenqube.intent.action.ACTION_TRAN_POPUP";
    private TextView appTitleTextView;
    private ImageView appImageView;

    public static void startActivity(Context context, TransactionPopupInfo transactionPopupInfo) throws ParameterException, AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        if (transactionPopupInfo == null) {
            throw new ParameterException("Check transactionPopupInfo.");
        }
        if (!PrefManager.getInstance(context).isEnabled("TENQUBE_TRAN_POPUP", true)) {
            return;
        }
        try {
            Intent intent = new Intent(context, TransactionPopupActivity.class);
            intent.addFlags(1409417216);
            intent.putExtra(ARG_TRANSACTION, (Serializable)transactionPopupInfo);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAppInfo() {
        PackageManager packageManager = this.getApplicationContext().getPackageManager();
        try {
            this.appImageView = (ImageView)this.findViewById(R.id.icon);
            this.appTitleTextView = (TextView)this.findViewById(R.id.title);
            String pkgName = this.getApplicationContext().getPackageName();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(pkgName, 128);
            Drawable icon = packageManager.getApplicationIcon(pkgName);
            this.appImageView.setImageDrawable(icon);
            String appName = (String)packageManager.getApplicationLabel(appInfo);
            this.appTitleTextView.setText((CharSequence)appName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            final TransactionPopupInfo transactionPopupInfo = (TransactionPopupInfo)this.getIntent().getSerializableExtra(ARG_TRANSACTION);
            if (transactionPopupInfo == null || !PrefManager.getInstance((Context)this).isEnabled("TENQUBE_TRAN_POPUP", true)) {
                this.finish();
                return;
            }
            AnswerManager.initFabric((Context)this);
            AnswerManager.onKeyMetric(new LogRequest("TransactionPopupActivity"));
            this.requestWindowFeature(1);
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.setContentView(R.layout.activity_transaction_popup);
            DisplayMetrics dm = new DisplayMetrics();
            this.getWindowManager().getDefaultDisplay().getMetrics(dm);
            this.setAppInfo();
            TextView companyTitleTextView = (TextView)this.findViewById(R.id.company_title);
            companyTitleTextView.setText((CharSequence)transactionPopupInfo.getCompanyTitle());
            TextView companyAddressTextView = (TextView)this.findViewById(R.id.company_address);
            companyAddressTextView.setVisibility(TextUtils.isEmpty((CharSequence)transactionPopupInfo.getCompanyAddress()) ? 8 : 0);
            companyAddressTextView.setText((CharSequence)transactionPopupInfo.getCompanyAddress());
            TextView spentDateTextView = (TextView)this.findViewById(R.id.spent_date);
            spentDateTextView.setText((CharSequence)transactionPopupInfo.getSpentDate());
            TextView paymentTextView = (TextView)this.findViewById(R.id.payment);
            paymentTextView.setText((CharSequence)transactionPopupInfo.getPayment());
            TextView installmentTextView = (TextView)this.findViewById(R.id.installment);
            installmentTextView.setText((CharSequence)transactionPopupInfo.getInstallmentStr());
            TextView spentMoneyTextView = (TextView)this.findViewById(R.id.spent_money);
            spentMoneyTextView.setText((CharSequence)transactionPopupInfo.getSpentMoneyStr());
            FrameLayout adContainer = (FrameLayout)this.findViewById(R.id.adContainer);
            View line = this.findViewById(R.id.line2);
            View adView = AdManager.getInstance((Context)this.getApplicationContext()).resultAdView;
            if (adView != null) {
                line.setVisibility(8);
                adContainer.removeAllViews();
                if (adView.getParent() != null) {
                    ((ViewGroup)adView.getParent()).removeView(adView);
                }
                adContainer.setVisibility(0);
                adContainer.addView(adView);
            } else {
                adContainer.setVisibility(8);
                line.setVisibility(0);
            }
            this.findViewById(R.id.go_detail).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        String path = Utils.makeDialogPath(transactionPopupInfo.getTranId(), transactionPopupInfo.getTransaction().getParsedTransaction().keyword, transactionPopupInfo.getCategory().getLarge(), transactionPopupInfo.getCategory().getMedium(), transactionPopupInfo.getCategory().getLargeCode(), transactionPopupInfo.getCategory().getMediumCode(), transactionPopupInfo.getTransaction().getParsedTransaction().spentDate, transactionPopupInfo.getTransaction().getSpentMoney(), transactionPopupInfo.getTransaction().getParsedTransaction().installmentCount, transactionPopupInfo.getTransaction().getCardId(), transactionPopupInfo.getTransaction().getParsedTransaction().memo, transactionPopupInfo.getTransaction().getParsedTransaction().dwType == 1 ? "expense" : "income", "popup");
                        VisualWebActivity.startActivity((Context)TransactionPopupActivity.this, path);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        TransactionPopupActivity.this.finish();
                    }
                }
            });
            this.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TransactionPopupActivity.this.finish();
                }
            });
            ImageView categoryImageView = (ImageView)this.findViewById(R.id.category);
            if (transactionPopupInfo.getLargeCode() == 10 || transactionPopupInfo.getLargeCode() == 90) {
                categoryImageView.setVisibility(8);
            } else {
                categoryImageView.setVisibility(0);
                categoryImageView.setImageResource(Utils.getCategoryIcon(transactionPopupInfo.getLargeCode()));
            }
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(new Intent(ACTION_TRAN_POPUP));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.finish();
        }
    }
}

