package com.tenqube.visual_third;

import android.Manifest;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.Switch;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.ui.OnResultListener;

import static com.tenqube.visual_third.Constants.ACTION_TRAN_POPUP;


public class MainActivity extends AppCompatActivity {

    private VisualService visualService;
    private LinearLayout container;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        try {
            // visual service 생성
            visualService = new VisualServiceImpl(this, "iZNnFACxmN7w7RERSwGSa6h6KdONndJP33UYTurl", Constants.PROD);
            visualService.setDebugMode(true); // 개발자 모드 설정 (로그 확인이 가능합니다.)

            // 알림 상태바에 나타느는 notification small icon 값 설정
            visualService.settingNotification(R.drawable.ic_deposit_loan, "1234","name", "des", 0); // 상단 노티 아이콘 설정

            // 팝업 설정
            Switch popup = (Switch) findViewById(R.id.popup);
            popup.setChecked(visualService.isActiveTranPopup());
            popup.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    visualService.setTranPopup(isChecked);
                }
            });

            // daily 알림 설정
            Switch daily = (Switch) findViewById(R.id.daily);
            daily.setChecked(visualService.isActiveDailyNoti());
            daily.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                    visualService.setDailyNoti(isChecked);
                }
            });

            // weekly 알림 설정
            Switch weekly = (Switch) findViewById(R.id.weekly);
            weekly.setChecked(visualService.isActiveWeeklyNoti());

            weekly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    visualService.setWeeklyNoti(isChecked);
                }
            });

            // monthly 알림설정
            Switch monthly = (Switch) findViewById(R.id.monthly);
            monthly.setChecked(visualService.isActiveMonthlyNoti());
            monthly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    visualService.setMonthlyNoti(isChecked);
                }
            });

            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_TRAN_POPUP);
            LocalBroadcastManager.getInstance(getApplicationContext()).registerReceiver(channelManageReceiver, filter);
            container = (LinearLayout) findViewById(R.id.adContainer);

            findViewById(R.id.ad).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
//                    visualService.setUserInfo(1987, Constants.UserSex.MALE);
                    AdManager.getInstance(getApplicationContext()).loadAd(new OnAdLoadedListener() {
                        @Override
                        public void onAdLoaded(View view) {
                            container.removeAllViews();
                            if(view.getParent() != null) {
                                ((ViewGroup)view.getParent()).removeView(view);
                            }
                            container.addView(view);


                        }
                    });
                }
            });

        } catch (ParameterException e) {
            e.printStackTrace();
        }

    }


    private BroadcastReceiver channelManageReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {

            Log.i("action", "tag");
        }
    };

//    /**
//     * 1. 맨처음 가입 이후 파싱 진행 가능
//     * 2. 가입 실패시
//     * @param view
//     */
//    public void onSignUp(View view) {
//
////    }
////        visualService.getAdView(new OnAdLoadedListener() {
////            @Override
////            public void onAdLoaded(final View ad) {
////                adView.post(new Runnable() {
////                    @Override
////                    public void run() {
////                        adView.addView(ad);
////                        adView.invalidate();
////                    }
////                });
////
////            }
////        });
//    }

    /**
     *
     * @param view
     */
    public void onWeb(View view) {

        try {
            if (ContextCompat.checkSelfPermission(MainActivity.this,
                    Manifest.permission.READ_SMS)
                    != PackageManager.PERMISSION_GRANTED) {

                // Should we show an explanation?
                if (ActivityCompat.shouldShowRequestPermissionRationale(MainActivity.this,
                        Manifest.permission.READ_SMS)) {



                } else {

                    ActivityCompat.requestPermissions(MainActivity.this,
                            new String[]{Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS},
                            0);

                }
            } else {
                visualService.startVisual("1234", new OnResultListener() {
                    @Override
                    public void onResult(int signUpResult, String msg) {

                    }
                });
            }


        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        switch (requestCode) {
            case 0: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    try {
                        visualService.startVisual("1234", new OnResultListener() {
                            @Override
                            public void onResult(int signUpResult, String msg) {

                            }
                        });
                    } catch (ParameterException e) {
                        e.printStackTrace();
                    }
                    // permission was granted, yay! Do the
                    // contacts-related task you need to do.

                } else {

                    // permission denied, boo! Disable the
                    // functionality that depends on this permission.
                }
                return;
            }

        }
    }

}
