/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.text.TextUtils;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.CAC;
import com.tenqube.visual_third.model.analysis.CategoryMax;
import com.tenqube.visual_third.model.analysis.Morning;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class MonthlyAnalysis
implements Runnable {
    private final int before;
    private final ArrayList<Transaction> transactions;
    public String monthStr;
    public HashMap<String, AggregationValue> month;
    private HashMap<String, AggregationValue> aggregateByDate;
    public HashMap<String, AggregationValue> cardType;
    public HashMap<String, AggregationValue> lcode;
    public HashMap<String, AggregationValue> mcode;
    public HashMap<String, AggregationValue> lkeyword;
    public HashMap<String, AggregationValue> fastfood;
    public Transaction maxTransaction;
    Morning morningCoffeeSum;
    Morning morningTaxiSum;
    public String maxCoffeeDate;
    public AggregationValue maxDateValue;
    public String maxDate;
    public String maxKeyword;
    public double maxSum;
    double samePeriodSum;
    ArrayList<CAC> cacs = new ArrayList();
    public HashMap<String, CategoryMax> maxKeywordsByCategory = new HashMap();

    public MonthlyAnalysis(ArrayList<Transaction> transactions, int before) {
        this.transactions = transactions;
        this.before = before;
    }

    @Override
    public void run() {
        this.monthStr = AnalysisHelper.getMonth(this.before) + "";
        ArrayList<Transaction> filteredTransactions = AnalysisHelper.filterTransactions(this.transactions, this.before);
        this.month = AnalysisHelper.aggregate(filteredTransactions, 0);
        if (this.before == 0 || this.before == 1) {
            this.aggregateByDate = AnalysisHelper.aggregate(filteredTransactions, 7);
            try {
                this.setMaxKeywordByCategory(filteredTransactions);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1 * this.before);
            calendar.add(5, 1);
            double sum = AnalysisHelper.getSumByLcode(filteredTransactions, 22, Utils.getYMD(calendar));
            this.cacs.add(new CAC(22, sum));
            sum = AnalysisHelper.getSumByLcode(filteredTransactions, 24, Utils.getYMD(calendar));
            this.cacs.add(new CAC(24, sum));
            sum = AnalysisHelper.getSumByLcode(filteredTransactions, 26, Utils.getYMD(calendar));
            this.cacs.add(new CAC(26, sum));
            AnalysisHelper.descCAC(this.cacs);
        }
        if (this.before != 0) {
            this.samePeriodSum = AnalysisHelper.getSamePeriodSum(filteredTransactions, this.before);
            this.maxTransaction = AnalysisHelper.getMaxKeyword(filteredTransactions);
        } else {
            ArrayList<Transaction> coffeeTransactions = AnalysisHelper.filterTransactionsMcode(filteredTransactions, 2411);
            HashMap<String, AggregationValue> aggregateByMcodeDate = AnalysisHelper.aggregate(coffeeTransactions, 7);
            ArrayList<AggregationValue> coffees = new ArrayList<AggregationValue>(aggregateByMcodeDate.values());
            if (!Utils.isEmpty(coffees)) {
                AnalysisHelper.desc(coffees);
                this.maxCoffeeDate = coffees.get(0).getTitle();
            }
        }
        this.cardType = AnalysisHelper.aggregate(filteredTransactions, 4);
        this.lcode = AnalysisHelper.aggregate(filteredTransactions, 2);
        this.mcode = AnalysisHelper.aggregate(filteredTransactions, 3);
        this.fastfood = AnalysisHelper.aggregate(AnalysisHelper.filterTransactionsMcode(filteredTransactions, 2212), 6);
        this.morningCoffeeSum = AnalysisHelper.getMorningSum(filteredTransactions, 2411);
        this.morningTaxiSum = AnalysisHelper.getMorningSum(filteredTransactions, 6216);
        this.calculateMaxDate();
    }

    private void calculateMaxDate() {
        ArrayList<AggregationValue> values;
        if (this.aggregateByDate != null && !Utils.isEmpty(values = new ArrayList<AggregationValue>(this.aggregateByDate.values()))) {
            AnalysisHelper.desc(values);
            this.maxDateValue = values.get(0);
            this.maxDate = this.maxDateValue.getTitle();
            this.maxSum = this.maxDateValue.getSum();
            ArrayList<Transaction> filteredTransactions = AnalysisHelper.filterTransactionsByDate(this.transactions, this.maxDate);
            Transaction transaction = AnalysisHelper.getMaxKeyword(filteredTransactions);
            if (transaction != null) {
                this.maxKeyword = transaction.getTransaction().getKeyword();
            }
        }
    }

    private void setMaxKeywordByCategory(ArrayList<Transaction> filteredTransactions) throws Exception {
        this.lkeyword = AnalysisHelper.aggregate(filteredTransactions, 2, 6);
        if (this.lkeyword != null && !this.lkeyword.isEmpty()) {
            ArrayList<AggregationValue> sumBylKeyword = new ArrayList<AggregationValue>(this.lkeyword.values());
            AnalysisHelper.desc(sumBylKeyword);
            for (AggregationValue value : sumBylKeyword) {
                String[] values;
                CategoryMax maxValue = this.maxKeywordsByCategory.get(value.getTitle());
                if (maxValue != null || (values = value.getKey().split(";")).length <= 0) continue;
                maxValue = new CategoryMax(value.getTitle(), value.getSum(), values[1]);
                this.maxKeywordsByCategory.put(value.getTitle(), maxValue);
            }
        }
    }

    public double getCACSum() {
        double sum = 0.0;
        for (CAC cac : this.cacs) {
            sum += cac.getSum();
        }
        return sum;
    }

    public String getCACStr(double monthSum) {
        ArrayList<String> values = new ArrayList<String>();
        for (CAC cac : this.cacs) {
            String percentStr = AnalysisHelper.getPercent(cac.getSum() * 100.0 / monthSum);
            switch (cac.getLcode()) {
                case 22: {
                    values.add("\uc2dd\uc0ac " + percentStr);
                    break;
                }
                case 24: {
                    values.add("\uce74\ud398/\uac04\uc2dd " + percentStr);
                    break;
                }
                case 26: {
                    values.add("\uc220/\uc720\ud765 " + percentStr);
                }
            }
        }
        return TextUtils.join((CharSequence)",\n", values);
    }
}

