/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.analysis;

import com.tenqube.visual_third.analysis.AnalysisHelper;

public class Result {
    private String displayValue;
    private String value;
    private double amount;

    public Result(String value) {
        this.value = value;
        this.displayValue = value;
    }

    public Result(String value, int type) {
        this.value = value;
        if (type != -1) {
            this.setDisplayValue(type);
        }
    }

    public Result(double value, int type) {
        this.amount = value;
        this.value = "" + value;
        if (type != -1) {
            this.setDisplayValue(type);
        }
    }

    public double getAmount() {
        return this.amount;
    }

    private void setDisplayValue(int type) {
        try {
            double value = Double.parseDouble(this.value);
            this.displayValue = type == 0 ? AnalysisHelper.getLv0Currency(value) : (type == 1 ? AnalysisHelper.getNumber(value) : (type == 2 ? AnalysisHelper.getNumberFirst(value) : (type == 4 ? AnalysisHelper.getCnt(value, "\ud68c") : AnalysisHelper.getPercent(value))));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Result{displayValue='" + this.displayValue + '\'' + ", value='" + this.value + '\'' + ", amount=" + this.amount + '}';
    }
}

