package com.tenqube.visual_third.analysis;

import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;
import java.util.Calendar;

import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactionsMcode;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMaxSpentDate;
import static com.tenqube.visual_third.util.Utils.getDiffDay;
import static com.tenqube.visual_third.util.Utils.toCalendar;

/**
 * Created by sagwangjin on 2018. 7. 22..
 */

public class LastSpentAnalysis implements Runnable {

    private final ArrayList<Transaction> transactions;
    public final int[] mcode;

    public Transaction lastTransaction;
    public int difDay;
    ArrayList<Transaction> filteredTransactions;


    public LastSpentAnalysis(ArrayList<Transaction> transactions, int... mcode) {
        this.transactions = transactions;
        this.mcode = mcode;
    }

    @Override
    public void run() {

        filteredTransactions = filterTransactionsMcode(transactions, mcode);
        Transaction lastTransaction = getMaxSpentDate(filteredTransactions);

        if(lastTransaction != null) {
            this.lastTransaction = lastTransaction;
            difDay = getDiffDay(toCalendar(lastTransaction.getTransaction().getSpentDate()), Calendar.getInstance());
        }
    }
}
