/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.content.Context;
import android.location.Location;
import com.tenqube.visual_third.core.FusedLocationManager;
import com.tenqube.visual_third.core.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.ui.TransactionPopupActivity;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.LogUtil;

class OneLoader {
    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private Context mContext;
    private final FusedLocationManager fusedLocationManager;
    private ParserService parserService;
    private int mServerCnt = 0;
    private VisualApi api;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneLoader getInstance(Context context) {
        Class<OneLoader> clazz = OneLoader.class;
        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private OneLoader(Context context) {
        this.mContext = context;
        this.fusedLocationManager = FusedLocationManager.getInstance(context);
        this.parserService = ParserService.getInstance((Context)context);
        this.api = VisualApi.getInstance(context);
    }

    public synchronized void doParsing(final SMS sms) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogUtil.LOGI((String)TAG, (String)("doParsing" + sms.toString()), (boolean)ParserService.mIsDebug);
                OneLoader.this.fusedLocationManager.loadLastLocation();
                ParserResult parserResult = OneLoader.this.parserService.parse(sms);
                if (parserResult.resultCode != 1 && "com.samsung.android.spay".equals(sms.sender)) {
                    sms.fullSms = sms.title;
                    parserResult = OneLoader.this.parserService.parse(sms);
                }
                LogUtil.LOGI((String)TAG, (String)("parserResult" + parserResult.resultCode + ResultCode.stringValueOf((Integer)parserResult.resultCode)), (boolean)ParserService.mIsDebug);
                switch (parserResult.resultCode) {
                    case -4: {
                        OneLoader.this.syncParsingRule();
                        break;
                    }
                    case -6: {
                        if (!Utils.shouldParsing(sms.fullSms)) break;
                        OneLoader.this.syncParsingRuleAndNoSender();
                        break;
                    }
                    case -5: {
                        break;
                    }
                    case 1: {
                        OneLoader.this.parsedSMS(parserResult.transactions);
                    }
                }
            }
        }).start();
    }

    private void syncParsingRuleAndNoSender() {
        ++this.mServerCnt;
        if (this.mServerCnt == 5) {
            this.mServerCnt = 0;
            this.syncParsingRule();
        }
    }

    private void parsedSMS(ArrayList<Transaction> transactions) {
        try {
            SearchCompanyResponse searchCompanyResponse;
            Transaction currentTran = this.getCurrentTransaction(transactions);
            if (currentTran != null) {
                this.addLocationInfo(currentTran);
            }
            if ((searchCompanyResponse = this.api.searchCompany(transactions)) != null && currentTran != null && currentTran.isDuplicate == 0) {
                this.checkCurrentTranInfo(searchCompanyResponse, currentTran);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Transaction getCurrentTransaction(ArrayList<Transaction> transactions) {
        for (Transaction transaction : transactions) {
            if (!transaction.isCurrentTran) continue;
            return transaction;
        }
        return null;
    }

    private void addLocationInfo(Transaction currentTran) {
        Location location = this.fusedLocationManager.getLocation();
        if (location != null) {
            currentTran.spentLatitude = location.getLatitude();
            currentTran.spentLongitude = location.getLongitude();
        } else {
            currentTran.spentLatitude = -1.0;
            currentTran.spentLongitude = -1.0;
        }
    }

    private void checkCurrentTranInfo(SearchCompanyResponse searchCompanyResponse, Transaction currentTran) {
        for (SearchCompanyResponse.TranCompany company : searchCompanyResponse.getResults()) {
            if (company.getIdentifier() != currentTran.identifier) continue;
            TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo(currentTran, company);
            try {
                TransactionPopupActivity.startActivity(this.mContext, transactionPopupInfo);
            }
            catch (ParameterException e) {
                e.printStackTrace();
            }
            catch (AuthException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    private void syncParsingRule() {
        this.parserService.syncParsingRule(this.api.syncParsingRule());
    }
}

