/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class CategoryDao {
    private final Db db;

    public CategoryDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() {
        String query = QueryGenerator.category();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    LogUtil.LOGI((String)"LOADALL", (String)ReaderContract.CategoryTable.populateModel(c).toString(), (boolean)ParserService.mIsDebug);
                    c.moveToNext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Category> loadCategories() {
        String query = QueryGenerator.categoryByMedium();
        ArrayList<Category> results = new ArrayList<Category>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.CategoryTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category loadCategory(String categoryCode) {
        String query = QueryGenerator.category(categoryCode);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst() && !c.isAfterLast()) {
                Category category = ReaderContract.CategoryTable.populateModel(c);
                return category;
            }
        }
        return null;
    }

    public void mergeCategory(SyncCategoryResponse.Category category) {
        try {
            if (category.isDeleted()) {
                this.db.delete(" CATEGORIES ", "_id=?", new String[]{category.getId() + ""});
            } else {
                ContentValues values = new ContentValues();
                values.put("_id", Integer.valueOf(category.getId()));
                values.put("cateCode", Integer.valueOf(category.getCategoryCode()));
                values.put("largeName", category.getLargeCategory());
                values.put("mediumName", category.getMediumCategory());
                values.put("smallName", category.getSmallCategory());
                this.db.insertOnReplace(" CATEGORIES ", values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

