/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.catcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import com.tenqube.visual_third.parser.catcher.SmsMmsService;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import java.util.Calendar;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

public class SMSTestCatcher
extends BroadcastReceiver {
    private String TAG = SMSTestCatcher.class.getSimpleName();
    public static final String SMS_TEST_ACTION = "ACTION_VISUAL_SMS_TEST";

    public void onReceive(final Context context, final Intent intent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Utils.isSDKDisabled(context)) {
                        return;
                    }
                    if (SMSTestCatcher.SMS_TEST_ACTION.equals(intent.getAction())) {
                        String msg = intent.getStringExtra("msg");
                        String sender = intent.getStringExtra("sender");
                        int smsType = intent.getIntExtra("smsType", Constants.SMSType.SMS.ordinal());
                        SMS sms = new SMS(1, msg, sender, sender, Utils.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance()), smsType);
                        SMSTestCatcher.this.sendIntentService(context, sms);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private SMS parseSms(Bundle bundle) {
        if (bundle != null) {
            String originMsg = "";
            String displayMsg = "";
            String originTel = "";
            String displayTel = "";
            long date = 0L;
            Object[] pdusObj = (Object[])bundle.get("pdus");
            if (pdusObj != null) {
                for (Object obj : pdusObj) {
                    SmsMessage currentMessage;
                    if (Build.VERSION.SDK_INT >= 23) {
                        String format = bundle.getString("format");
                        currentMessage = SmsMessage.createFromPdu((byte[])((byte[])obj), (String)format);
                    } else {
                        currentMessage = SmsMessage.createFromPdu((byte[])((byte[])obj));
                    }
                    if (currentMessage == null) continue;
                    if (currentMessage.getDisplayOriginatingAddress() != null) {
                        displayTel = currentMessage.getDisplayOriginatingAddress();
                    }
                    if (currentMessage.getOriginatingAddress() != null) {
                        originTel = currentMessage.getOriginatingAddress();
                    }
                    if (currentMessage.getTimestampMillis() != 0L) {
                        date = currentMessage.getTimestampMillis();
                    }
                    if (currentMessage.getMessageBody() != null) {
                        originMsg = originMsg + currentMessage.getMessageBody();
                    }
                    if (currentMessage.getDisplayMessageBody() == null) continue;
                    displayMsg = displayMsg + currentMessage.getDisplayMessageBody();
                }
                if (!(displayTel == null && originTel == null || TextUtils.isEmpty((CharSequence)displayTel) && TextUtils.isEmpty((CharSequence)originTel) || TextUtils.isEmpty((CharSequence)displayMsg) && TextUtils.isEmpty((CharSequence)originMsg))) {
                    String fullSms = this.selectMsg(originMsg, displayMsg);
                    return new SMS(0, fullSms, originTel, displayTel, Utils.getConvertedDate(date), Constants.SMSType.SMS.ordinal());
                }
            }
        }
        return null;
    }

    private void sendIntentService(Context context, SMS sms) {
        Intent startIntent = new Intent(context, SmsMmsService.class);
        startIntent.putExtra("ARG_SMS", (Serializable)sms);
        context.startService(startIntent);
    }

    private String selectMsg(String originMsg, String displayMsg) {
        if (TextUtils.isEmpty((CharSequence)originMsg)) {
            return displayMsg;
        }
        if (TextUtils.isEmpty((CharSequence)displayMsg)) {
            return originMsg;
        }
        String msg = originMsg.equals(displayMsg) ? originMsg : displayMsg;
        return msg;
    }
}

