package com.tenqube.visual_third.db;

import android.content.ContentValues;
import android.content.Context;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;

import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.ClipCategory;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.entity.UserCategory;
import com.tenqube.visual_third.entity.VisualNotification;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import tenqube.parser.constants.Constants;

import static tenqube.parser.util.LogUtil.makeLogTag;

public class DatabaseHelper extends SQLiteOpenHelper {

    private static DatabaseHelper mInstance = null;
    private static final String DATABASE_NAME = "visual.db";
    private static final int DATABASE_VERSION = 2;
    private static final String TAG = makeLogTag(DatabaseHelper.class);
    private Context mContext;

    public static DatabaseHelper getInstance(Context context) {
        synchronized (DatabaseHelper.class) {
            if (mInstance == null) {
                mInstance = new DatabaseHelper(context);
            }
            return mInstance;
        }
    }

    private DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        mContext = context;
    }

    @Override
    public void onCreate(SQLiteDatabase db) throws SQLiteException {

        // create table
        db.execSQL(ReaderContract.CardTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.UserCategoryTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.CategoryTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.TransactionsTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.ContentTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.ConditionTable.SQL_CREATE_ENTRIES);
        db.execSQL(ReaderContract.CurrencyTable.SQL_CREATE_TABLE);
        db.execSQL(ReaderContract.NotificationsTable.SQL_CREATE_TABLE);
        db.execSQL(ReaderContract.ClipCategoryTable.SQL_CREATE_ENTRIES);

        db.execSQL(ReaderContract.AdvertisementTable.SQL_CREATE_ENTRIES);

        // index
        db.execSQL(ReaderContract.CardTable.indexing);
        db.execSQL(ReaderContract.TransactionsTable.indexing);
        db.execSQL(ReaderContract.TransactionsTable.indexing2);

        db.execSQL(ReaderContract.ContentTable.indexing);
        db.execSQL(ReaderContract.ConditionTable.indexing);


        // default value
        insertCategories(db);
        insertUserCategories(db);
        insertContents(db);
        insertConditions(db);
        insertCurrency(db);
        insertCash(db);
        insertNotifications(db);
        insertClipCategories(db);

    }

    private void insertCash(SQLiteDatabase db) throws SQLiteException {
        ContentValues values = new ContentValues();
        values.put(ReaderContract.CardTable.COLUMN_CARD_NAME, "현금");
        values.put(ReaderContract.CardTable.COLUMN_CHANGE_NAME, "현금");

        values.put(ReaderContract.CardTable.COLUMN_CARD_TYPE, Constants.CardType.CASH.ordinal());
        values.put(ReaderContract.CardTable.COLUMN_CHANGE_TYPE, Constants.CardType.CASH.ordinal());

        values.put(ReaderContract.CardTable.COLUMN_CARD_SUB_TYPE, 0);
        values.put(ReaderContract.CardTable.COLUMN_CHANGE_SUB_TYPE, 0);

        values.put(ReaderContract.CardTable.COLUMN_BILLING_DAY, 1);

        db.insert(ReaderContract.CardTable.TABLE_NAME, null, values);

    }

    private void insertCategories(SQLiteDatabase db) throws SQLiteException {

        if(db != null) {
            ArrayList<String> values = new ArrayList<>();
            AssetManager am = mContext.getAssets();
            InputStream inStream;
            int i  = 0;
            try {
                inStream = am.open("categories.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                String line ;
                while ((line = buffer.readLine()) != null) {
                    if(i == 0){
                        i++;
                        continue;
                    }

                    String[] colums = line.split("\t");
                    Category category = new Category(
                            Integer.parseInt(colums[0]),
                            Integer.parseInt(colums[1]),
                            colums[2],
                            colums[3],
                            colums[4]);

                    values.add(category.getInsertValue());
                    i++;
                }

                if(!values.isEmpty()) {
                    String insertQuery = ReaderContract.CategoryTable.INSERT_QUERY + TextUtils.join(",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertUserCategories(SQLiteDatabase db) throws SQLiteException {
        // 대분류 목록 가져온후
        // 디폴트 값 넣어주기
        ArrayList<String> values = new ArrayList<>();
        values.add(new UserCategory(1, 101010, false, false).getInsertValue());
        values.add(new UserCategory(2, 221010, false, false).getInsertValue());
        values.add(new UserCategory(3, 241010, false, false).getInsertValue());
        values.add(new UserCategory(4, 261010, false, false).getInsertValue());
        values.add(new UserCategory(5, 321010, false, false).getInsertValue());
        values.add(new UserCategory(6, 341010, false, false).getInsertValue());
        values.add(new UserCategory(7, 361010, false, false).getInsertValue());
        values.add(new UserCategory(8, 421010, false, false).getInsertValue());
        values.add(new UserCategory(9, 441010, false, false).getInsertValue());
        values.add(new UserCategory(10, 461010, false, false).getInsertValue());
        values.add(new UserCategory(11, 521010, false, false).getInsertValue());
        values.add(new UserCategory(12, 541010, false, false).getInsertValue());
        values.add(new UserCategory(13, 561010, false, false).getInsertValue());
        values.add(new UserCategory(14, 621010, false, false).getInsertValue());
        values.add(new UserCategory(15, 641010, false, false).getInsertValue());
        values.add(new UserCategory(16, 661010, false, false).getInsertValue());
        values.add(new UserCategory(17, 821010, false, false).getInsertValue());
        values.add(new UserCategory(18, 841010, false, false).getInsertValue());
        values.add(new UserCategory(19, 881010, true, false).getInsertValue());
        values.add(new UserCategory(20, 901010, false, false).getInsertValue());
        values.add(new UserCategory(21, 921010, false, false).getInsertValue());
        values.add(new UserCategory(22, 941010, false, false).getInsertValue());
        values.add(new UserCategory(23, 961010, false, false).getInsertValue());
        values.add(new UserCategory(24, 981010, true, false).getInsertValue());

        String insertQuery = ReaderContract.UserCategoryTable.INSERT_QUERY + TextUtils.join(",", values);
        db.execSQL(insertQuery);
        values.clear();

    }

    private void insertContents(SQLiteDatabase db) throws SQLiteException {

        if(db != null) {
            ArrayList<String> values = new ArrayList<>();
            AssetManager am = mContext.getAssets();
            InputStream inStream;
            int i  = 0;
            try {
                inStream = am.open("contents.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                String line ;
                while ((line = buffer.readLine()) != null) {
                    if(i == 0){
                        i++;
                        continue;
                    }

                    String[] colums = line.split("\t");
                    Content contents = new Content(
                            Integer.parseInt(colums[0]),
                            Integer.parseInt(colums[1]),
                            Integer.parseInt(colums[2]),
                                    Integer.parseInt(colums[3]),
                            Integer.parseInt(colums[4]),
                            colums[5],
                            colums[6],
                            colums[7],
                            colums[8],
                            colums[9],
                            colums[10],
                            colums[11],
                            colums[12]
                    );
                    values.add(contents.getInsertValue());
                    i++;
                }

                if(!values.isEmpty()) {
                    String insertQuery = ReaderContract.ContentTable.INSERT_QUERY + TextUtils.join(",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertConditions(SQLiteDatabase db) throws SQLiteException {

        if(db != null) {
            ArrayList<String> values = new ArrayList<>();
            AssetManager am = mContext.getAssets();
            InputStream inStream;
            int i  = 0;
            try {
                inStream = am.open("conditions.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                String line ;
                while ((line = buffer.readLine()) != null) {
                    if(i == 0){
                        i++;
                        continue;
                    }

                    String[] colums = line.split("\t");
                    Condition condition = new Condition(
                            Integer.parseInt(colums[0]),
                            Integer.parseInt(colums[1]),
                            colums[2],
                            colums[3],
                            colums[4]
                    );

                    values.add(condition.getInsertValue());
                    i++;
                }

                if(!values.isEmpty()) {
                    String insertQuery = ReaderContract.ConditionTable.INSERT_QUERY + TextUtils.join(",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * asset 파일정보를 가지고 테이블 초기화
     */
    public void insertCurrency(SQLiteDatabase db) {

        ArrayList<String> currencies = new ArrayList<>();
        AssetManager am = mContext.getAssets();
        InputStream inStream;
        BufferedReader buffer;
        try {
            inStream = am.open("currency.tsv");
            buffer = new BufferedReader(new InputStreamReader(inStream));
            String line = "";
            int i  = 0;
            while ((line = buffer.readLine()) != null) {
                if(i == 0){
                    i++;
                    continue;
                }

                String[] colums = line.split("\t");

                currencies.add(new Currency(0,
                        colums[0],
                        colums[1],
                        Double.parseDouble(colums[2]),
                        colums[3]).insertValues());

                if(currencies.size() == 50) {
                    String insertQuery = ReaderContract.CurrencyTable.INSERT_CURRENCY + TextUtils.join(",", currencies);
                    db.execSQL(insertQuery);
                    currencies.clear();
                }
            }

            if (inStream != null)
                inStream.close();
            if (buffer != null)
                buffer.close();

            if(currencies.size() != 0) {
                String insertQuery = ReaderContract.CurrencyTable.INSERT_CURRENCY + TextUtils.join(",", currencies);
                db.execSQL(insertQuery);
                currencies.clear();
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        } catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    public void insertNotifications(SQLiteDatabase db) {

        ArrayList<String> notifications = new ArrayList<>();
        AssetManager am = mContext.getAssets();
        InputStream inStream;
        BufferedReader buffer;
        try {
            inStream = am.open("notifications.tsv");
            buffer = new BufferedReader(new InputStreamReader(inStream));
            String line = "";
            int i  = 0;
            while ((line = buffer.readLine()) != null) {
                if(i == 0){
                    i++;
                    continue;
                }

                String[] colums = line.split("\t");

                notifications.add(new VisualNotification(Integer.parseInt(colums[0]),//id
                        colums[1],//name
                        colums[2],//title
                        colums[3],//content
                        colums[4],//ticker
                        Integer.parseInt(colums[5]),//alarm_type
                        Integer.parseInt(colums[6]), // day_of_week
                        Integer.parseInt(colums[7]),// hour
                        Integer.parseInt(colums[8]),// day
                        // 9 == version
                        Integer.parseInt(colums[10]) == 1, //enable
                        colums[11] //created_at

                ).insertValues());

                if(notifications.size() == 50) {
                    String insertQuery = ReaderContract.NotificationsTable.INSERT_NOTIFICATION + TextUtils.join(",", notifications);
                    db.execSQL(insertQuery);
                    notifications.clear();
                }
            }

            if (inStream != null)
                inStream.close();
            if (buffer != null)
                buffer.close();

            if(notifications.size() != 0) {
                String insertQuery = ReaderContract.NotificationsTable.INSERT_NOTIFICATION + TextUtils.join(",", notifications);
                db.execSQL(insertQuery);
                notifications.clear();
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        } catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    public void insertClipCategories(SQLiteDatabase db) {

        ArrayList<String> categories = new ArrayList<>();
        AssetManager am = mContext.getAssets();
        InputStream inStream;
        BufferedReader buffer;
        try {
            inStream = am.open("clip_category.tsv");
            buffer = new BufferedReader(new InputStreamReader(inStream));
            String line = "";
            int i  = 0;
            while ((line = buffer.readLine()) != null) {
                if(i == 0){
                    i++;
                    continue;
                }

                String[] colums = line.split("\t");

                categories.add(new ClipCategory(Integer.parseInt(colums[0]),//id
                        Integer.parseInt(colums[1]), //category code
                        colums[2],// name
                        colums[3]).getInsertValue());

                if(categories.size() == 50) {
                    String insertQuery = ReaderContract.ClipCategoryTable.INSERT_QUERY + TextUtils.join(",", categories);
                    db.execSQL(insertQuery);
                    categories.clear();
                }
            }

            if (inStream != null)
                inStream.close();
            if (buffer != null)
                buffer.close();

            if(categories.size() != 0) {
                String insertQuery = ReaderContract.ClipCategoryTable.INSERT_QUERY + TextUtils.join(",", categories);
                db.execSQL(insertQuery);
                categories.clear();
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        } catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) throws SQLiteException {

        if (newVersion > oldVersion) {
            switch (oldVersion) {

                case 1:

                    db.execSQL(ReaderContract.AdvertisementTable.SQL_CREATE_ENTRIES);

                    db.execSQL(ReaderContract.ContentTable.SQL_DELETE_ENTRIES);
                    db.execSQL(ReaderContract.ContentTable.SQL_CREATE_ENTRIES);
                    insertContents(db);

                    db.execSQL(ReaderContract.ConditionTable.SQL_DELETE_ENTRIES);
                    db.execSQL(ReaderContract.ConditionTable.SQL_CREATE_ENTRIES);
                    insertConditions(db);

                    db.execSQL(ReaderContract.NotificationsTable.SQL_CREATE_TABLE);
                    insertNotifications(db);

                    db.execSQL(ReaderContract.ClipCategoryTable.SQL_CREATE_ENTRIES);
                    insertNotifications(db);

                    break;
            }
        }

    }

}