/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.exception.ParameterException;
import java.io.Serializable;
import java.util.ArrayList;
import tenqube.parser.constants.Constants;

public class SearchCompanyRequest
implements Serializable {
    private ArrayList<Transaction> transactions;

    public SearchCompanyRequest(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    public static class Transaction {
        @SerializedName(value="id")
        String identifier;
        @SerializedName(value="keyword")
        String keyword;
        String type;
        String at;
        String method;
        double amount;
        String amountType;
        double lat;
        @SerializedName(value="long")
        double lng;

        public Transaction(tenqube.parser.model.Transaction transaction) throws ParameterException {
            if (transaction == null || TextUtils.isEmpty((CharSequence)transaction.spentDate)) {
                throw new ParameterException(transaction == null ? "transaction is null" : "spentDate" + transaction.spentDate);
            }
            this.identifier = transaction.identifier;
            this.keyword = transaction.keyword;
            this.type = transaction.dwType == Constants.DWType.DEPOSIT.ordinal() ? "deposit" : "withdraw";
            this.at = transaction.spentDate;
            this.method = transaction.cardType == 0 ? "debit" : (transaction.cardType == 1 ? "credit" : "account");
            this.amount = transaction.spentMoney;
            this.amountType = TextUtils.isEmpty((CharSequence)transaction.currency) ? "KRW" : transaction.currency;
            this.lat = transaction.spentLatitude;
            this.lng = transaction.spentLongitude;
        }
    }
}

