/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.tenqube.visual_third.OnResultListener;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.core.BulkLoader;
import com.tenqube.visual_third.core.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.SignUpRequest;
import com.tenqube.visual_third.ui.ProgressDialogFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int FINISH = 0;
    public static final int PROGRESS = 1;
    public static final int SHOW_PROGRESS_BAR = 2;
    public static final int ERROR = 3;
    private PrefManager prefManager;
    private AppCompatActivity activity;
    private VisualApi api;
    private ProgressDialogFragment progressDialog;
    private BulkLoader bulkLoader;
    private ParserService parserService;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (VisualServiceImpl.this.isActive()) {
                switch (msg.what) {
                    case 1: {
                        Bundle bundle;
                        if (VisualServiceImpl.this.progressDialog == null || !VisualServiceImpl.this.progressDialog.isAdded() || (bundle = msg.getData()) == null) break;
                        VisualServiceImpl.this.progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                        break;
                    }
                    case 2: {
                        if (VisualServiceImpl.this.progressDialog == null) {
                            VisualServiceImpl.this.progressDialog = ProgressDialogFragment.newInstance();
                            VisualServiceImpl.this.progressDialog.setCancelable(false);
                        }
                        try {
                            if (VisualServiceImpl.this.progressDialog.isAdded()) break;
                            FragmentManager fragmentManager = VisualServiceImpl.this.activity.getSupportFragmentManager();
                            VisualServiceImpl.this.progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                        }
                        catch (ClassCastException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        VisualServiceImpl.this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED", true);
                        if (VisualServiceImpl.this.progressDialog == null || !VisualServiceImpl.this.progressDialog.isAdded()) break;
                        VisualServiceImpl.this.progressDialog.dismiss();
                    }
                }
            }
            return false;
        }
    });

    public VisualServiceImpl(@NonNull AppCompatActivity activity) throws ParameterException {
        if (activity == null) {
            throw new ParameterException("activity is null");
        }
        this.activity = activity;
        this.prefManager = PrefManager.getInstance((Context)activity);
        this.api = VisualApi.getInstance((Context)activity);
        this.parserService = ParserService.getInstance((Context)activity);
        this.bulkLoader = new BulkLoader((Context)activity, this.handler, new BulkLoader.OnSmsLoadFinished(){

            @Override
            public void onFinished(boolean isError) {
                try {
                    if (VisualServiceImpl.this.handler != null) {
                        VisualServiceImpl.this.handler.sendEmptyMessage(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void signUp(@NonNull String custId, @NonNull OnResultListener onResultListener) throws ParameterException {
        Validator.isCustId(custId);
        LogUtil.LOGI((String)TAG, (String)"\uac00\uc785", (boolean)ParserService.mIsDebug);
        this.api.signUp(new SignUpRequest(custId), onResultListener);
    }

    @Override
    public void startVisual() throws AuthException, SecurityException {
        if (TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("UID is empty");
        }
        if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false)) {
            LogUtil.LOGI((String)TAG, (String)"\ubc8c\ud06c \ud30c\uc2f1 \uc9c4\ud589", (boolean)ParserService.mIsDebug);
            this.startBulkParsing();
        } else {
            try {
                LogUtil.LOGI((String)TAG, (String)"\uc6f9 \uac00\uacc4\ubd80 \ud638\ucd9c", (boolean)ParserService.mIsDebug);
                VisualWebActivity.startActivity((Context)this.activity, "main");
            }
            catch (ParameterException e) {
                e.printStackTrace();
            }
        }
    }

    private void startBulkParsing() throws SecurityException {
        LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
        if (this.isActive()) {
            LogUtil.LOGI((String)TAG, (String)"1. \ud37c\ubbf8\uc158 \uccb4\ud06c", (boolean)ParserService.mIsDebug);
            if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_MMS") != 0) {
                throw new SecurityException("Please grant permissions (Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS, Manifest.permission.RECEIVE_MMS)");
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LogUtil.LOGI((String)TAG, (String)"2. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                        VisualServiceImpl.this.handler.sendEmptyMessage(2);
                        LogUtil.LOGI((String)TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                        VisualServiceImpl.this.bulkLoader.doParsing();
                    }
                    catch (Exception e) {
                        VisualServiceImpl.this.handler.sendEmptyMessage(3);
                    }
                }
            }).start();
        }
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        LogUtil.LOGI((String)TAG, (String)"setDebugMode", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isDebug);
        }
    }

    @Override
    public void initSDK() {
        LogUtil.LOGI((String)TAG, (String)"initSDK", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    private boolean isActive() {
        return this.activity != null && !this.activity.isFinishing();
    }
}

