package com.tenqube.visual_third.entity;

import com.tenqube.visual_third.model.api.AdResponse;

import java.io.Serializable;

public class Advertisement implements Serializable {

    /**
     * 광고 고유 id
     */
    private int id;

    /**
     * 제목
     */
    private String title;

    /**
     * 라벨 정보
     */
    private String label;

    /**
     * 내용
     */
    private String content;

    /**
     * 연결 url
     */
    private String linkTo;

    /**
     *  마켓, webview, deeplink
     */
    private String linkToType;

    /**
     * 연결 url txt
     */
    private String linkToStr;

    /**
     * 이미지 URL
     */
    private String image;

    /**
     * 이미지 URL
     */
    private String iconImage;


    private int priority;

    private String query;

    private AdResponse.Admob colors;


    public Advertisement(int id, String title, String label, String content, String linkTo, String linkToType, String linkToStr, String image, String iconImage, int priority, String query, AdResponse.Admob colors) {
        this.id = id;
        this.title = title;
        this.label = label;
        this.content = content;
        this.linkTo = linkTo;
        this.linkToType = linkToType;
        this.linkToStr = linkToStr;
        this.image = image;
        this.iconImage = iconImage;
        this.priority = priority;
        this.query = query;
        this.colors = colors;
    }

    public int getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public String getLabel() {
        return label;
    }

    public String getContent() {
        return content;
    }

    public String getLinkTo() {
        return linkTo;
    }

    public String getLinkToType() {
        return linkToType;
    }

    public String getLinkToStr() {
        return linkToStr;
    }

    public String getImage() {
        return image;
    }

    public String getIconImage() {
        return iconImage;
    }

    public int getPriority() {
        return priority;
    }

    public String getQuery() {
        return query;
    }

    public AdResponse.Admob getColors() {
        return colors;
    }
}
