package com.tenqube.visual_third.parser.loader;

import android.content.Context;

import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.CurrencyManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.repository.VisualRepository;

import java.util.ArrayList;

import tenqube.parser.core.ParserService;
import tenqube.parser.model.Bank;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.RegData;
import tenqube.parser.model.Sender;

import static com.tenqube.visual_third.Constants.RULE_VERSION;
import static com.tenqube.visual_third.manager.PrefManager.PARSING_RULE_KEY;
import static com.tenqube.visual_third.manager.PrefManager.PARSING_RULE_VERSION;

class BaseLoader {

    final Context mContext;
    ParserService parserService;
    VisualApi api;
    PrefManager prefManager;
    VisualRepository repository;
    private CurrencyManager currencyManager;

    BaseLoader(Context context) {
        this.mContext = context;

        this.parserService = ParserService.getInstance(context);
        parserService.setDebugMode(true);
        this.api = VisualApi.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
        this.prefManager = PrefManager.getInstance(context);
        this.currencyManager = CurrencyManager.getInstance(context);

        syncParsingRuleKey();
    }

    private void syncParsingRuleKey() {
        try {
            if(!prefManager.isEnabled(PARSING_RULE_KEY, false)) {
                ParsingRuleKey parsingRuleKey = api.syncParsingRuleKey();
                if(parsingRuleKey != null) {
                    ParsingRule parsingRule = new ParsingRule(parsingRuleKey.getSecurityKey(), parsingRuleKey.getTranCount(), RULE_VERSION, new ArrayList<RegData>(), new ArrayList<Sender>(), new ArrayList<Bank>());
                    parserService.syncParsingRule(parsingRule);
                    prefManager.saveBoolean(PARSING_RULE_KEY, true);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void syncParsingRule() {
        String[] authInfo = api.getAuthInfo();
        VersionResponse versionResponse = api.syncVersion(authInfo[VisualApi.API_KEY]);
        int clientVersion = prefManager.loadIntValue(PARSING_RULE_VERSION, RULE_VERSION);

        if(versionResponse != null && versionResponse.getParsingRule() > clientVersion) {
            ParsingRule parsingRule = api.syncParsingRule(authInfo, clientVersion, versionResponse.getParsingRule());
            if(parsingRule != null) {
                parserService.syncParsingRule(parsingRule);
                prefManager.saveIntValue(PARSING_RULE_VERSION, parsingRule.ruleVersion);
            }
        }
    }

    void setCurrency(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {
        for(com.tenqube.visual_third.model.parser.Transaction parsedTran : transactions) {
            // 환율 계산
            parsedTran.setSpentMoney(currencyManager.calculateSpentMoney(parsedTran.getParsedTransaction().spentMoney, parsedTran.getParsedTransaction().currency));
        }
    }

}
