/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.database.Cursor;
import android.text.TextUtils;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Currency;
import java.util.ArrayList;

public class CurrencyDao {
    private final Db db;

    public CurrencyDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Currency loadCurrencyInfo(String from, String to) {
        String query = QueryGenerator.currency(from, to);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                Currency currency = ReaderContract.CurrencyTable.populateModel(c);
                return currency;
            }
        }
        return null;
    }

    public void mergeCurrency(Currency currency) {
        try {
            this.db.insertOnReplace(" CURRENCY ", ReaderContract.CurrencyTable.populateContent(currency));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mergeCurrency(ArrayList<String> currencies) {
        try {
            this.db.runQuery("INSERT OR REPLACE INTO CURRENCY (currency_from,currency_to,currency_rate,currency_created_at)VALUES" + TextUtils.join((CharSequence)",", currencies));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

