/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.text.TextUtils;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.UUID;

public class LogManager {
    private static LogManager mInstance = null;
    private VisualApi callApi;
    private Context mContext;
    private String uid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogManager getInstance(Context ctx) {
        Class<LogManager> clazz = LogManager.class;
        synchronized (LogManager.class) {
            if (mInstance == null) {
                mInstance = new LogManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private LogManager(Context mContext) {
        this.mContext = mContext;
        this.callApi = VisualApi.getInstance(mContext);
        this.uid = PrefManager.getInstance(mContext).loadStringValue("TENQUBE_UUID", "");
        if (TextUtils.isEmpty((CharSequence)this.uid)) {
            this.uid = UUID.randomUUID().toString();
            PrefManager.getInstance(mContext).saveStringValue("TENQUBE_UUID", this.uid);
        }
    }

    public void saveLog(String msg) {
        String custId = PrefManager.getInstance(this.mContext).loadStringValue("TENQUBE_UID", "");
        String createAt = Utils.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance());
        this.callApi.saveLog(new Log(this.uid, custId, createAt, msg));
    }

    public static class Log
    implements Serializable {
        private String uid;
        private String custId;
        private String date;
        private String msg;

        public Log(String uid, String custId, String date, String msg) {
            this.uid = uid;
            this.custId = custId;
            this.date = date;
            this.msg = msg;
        }
    }
}

