package com.tenqube.visual_third.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.LogManager;
import com.tenqube.visual_third.manager.ResourceManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;
import com.tenqube.visual_third.util.Utils;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;


public class AlarmReceiver extends BroadcastReceiver {

    protected static final String TAG = AlarmReceiver.class.getSimpleName();

    public static final String ACTION_TENQUBE_NOTIFICATION = "ACTION_TENQUBE_NOTIFICATION";
    @Override
    public void onReceive(final Context context, Intent intent) {


        LogManager.getInstance(context).saveLog("AlarmReceiver onReceive" + intent.getAction());

        if (Intent.ACTION_BOOT_COMPLETED.equals(intent.getAction()) ||
                Intent.ACTION_LOCKED_BOOT_COMPLETED.equals(intent.getAction())) {
            VisualAlarmManager.getInstance(context).setAlarms();
        } else if(ACTION_TENQUBE_NOTIFICATION.equals(intent.getAction())) {
            LOGI("ALARM", "Bundle" + intent.getBundleExtra("bundle"), true);
            try {

                Bundle bundle = intent.getBundleExtra("bundle");
                if (bundle != null) {
                    VisualNotification notification = (VisualNotification) bundle.getSerializable("data");
                    if(notification != null) {
                        VisualNotificationManager.getInstance(context).showNotification(notification);
                    } else {
                        LOGI(TAG, "notification == null", mIsDebug);
                    }
                } else {
                    LOGI(TAG, "bundle == null", mIsDebug);
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                VisualAlarmManager.getInstance(context).syncNotification();
                VisualAlarmManager.getInstance(context).setAlarms();
            }


        }
    }

}
