package com.tenqube.visual_third.manager;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.print.PrintManager;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;

import java.io.Serializable;
import java.util.Calendar;
import java.util.UUID;

public class LogManager {

    private static LogManager mInstance = null;
    private VisualApi callApi;
    private Context mContext;
    private String uid;


    public static LogManager getInstance(Context ctx) {

        synchronized (LogManager.class) {
            if (mInstance == null) {
                mInstance = new LogManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    private LogManager(Context mContext) {
        this.mContext = mContext;
        this.callApi = VisualApi.getInstance(mContext);
        uid = PrefManager.getInstance(mContext).loadStringValue(PrefManager.UUID, "");

        if(TextUtils.isEmpty(uid)) {
            uid = UUID.randomUUID().toString();
            PrefManager.getInstance(mContext).saveStringValue(PrefManager.UUID, uid);
        }

    }

    public void saveLog(String msg) {
        String custId = PrefManager.getInstance(mContext).loadStringValue(PrefManager.UID, "");
        String createAt = Utils.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance());
        callApi.saveLog(new Log(uid, custId, createAt, msg));
    }

    public static class Log implements Serializable {

        private String uid;
        private String custId;
        private String date;
        private String msg;

        public Log(String uid, String custId, String date, String msg) {
            this.uid = uid;
            this.custId = custId;
            this.date = date;
            this.msg = msg;
        }
    }


}
