package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.ClipCategory;
import com.tenqube.visual_third.model.api.SyncClipCategoryResponse;

import java.util.ArrayList;

public class ClipCategoryDao {

    private final Db db;

    public ClipCategoryDao(Db db) {
        this.db = db;
    }

    public ArrayList<ClipCategory> loadCategories() {

        String query = QueryGenerator.clipCategory();
        ArrayList<ClipCategory> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.ClipCategoryTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public ClipCategory loadCategory(String categoryCode) {

        String query = QueryGenerator.clipCategory(categoryCode);
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        return ReaderContract.ClipCategoryTable.populateModel(c);
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return null;
    }

    public void mergeCategory(SyncClipCategoryResponse.Category category) {

        try {
            if(category.isDeleted()) {
                db.delete(ReaderContract.ClipCategoryTable.TABLE_NAME, ReaderContract.CategoryTable._ID + "=?" , new String[]{category.getId() + ""});
            } else {
                ContentValues values = new ContentValues();
                values.put(ReaderContract.ClipCategoryTable._ID, category.getId());
                values.put(ReaderContract.ClipCategoryTable.COLUMN_CODE, category.getCategoryCode());
                values.put(ReaderContract.ClipCategoryTable.COLUMN_NAME, category.getName());
                values.put(ReaderContract.ClipCategoryTable.COLUMN_UID, category.getUid());
                db.insertOnReplace(ReaderContract.ClipCategoryTable.TABLE_NAME, values);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
