/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.text.format.DateFormat;
import android.widget.TimePicker;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import java.util.Calendar;

public class TimePickerFragment
extends DialogFragment
implements TimePickerDialog.OnTimeSetListener {
    private static final String ARG_CAL = "calendar";
    private Callback mListener;
    private Calendar calendar = Calendar.getInstance();
    private TimeRequest timeRequest;

    public static TimePickerFragment newInstance(TimeRequest timeRequest) {
        TimePickerFragment fragment = new TimePickerFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_CAL, (Serializable)timeRequest);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.timeRequest = (TimeRequest)this.getArguments().getSerializable(ARG_CAL);
            if (this.timeRequest != null) {
                this.calendar = Utils.toCalendarHMS(this.timeRequest.getTime());
            }
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int hour = this.calendar.get(11);
        int minute = this.calendar.get(12);
        return new TimePickerDialog((Context)this.getActivity(), R.style.PickerTheme, (TimePickerDialog.OnTimeSetListener)this, hour, minute, DateFormat.is24HourFormat((Context)this.getActivity()));
    }

    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.onTimeCalendar(Utils.getHMS(this.calendar), this.timeRequest.getCallbackJS());
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof Callback)) {
            throw new RuntimeException(context.toString() + " must implement OnFragmentInteractionListener");
        }
        this.mListener = (Callback)context;
    }

    public void onTimeCalendar(String time, String callback) {
        if (this.mListener != null) {
            this.mListener.onCalendar(time, callback);
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static interface Callback {
        public void onCalendar(String var1, String var2);
    }
}

