/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.content.Context;
import com.google.gson.Gson;
import com.tenqube.visual_third.OnResultListener;
import com.tenqube.visual_third.core.AddHeaderInterceptor;
import com.tenqube.visual_third.core.AddSearchHeaderInterceptor;
import com.tenqube.visual_third.core.SearchApiService;
import com.tenqube.visual_third.core.VisualApiService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.SearchCompanyRequest;
import com.tenqube.visual_third.model.SearchCompanyResponse;
import com.tenqube.visual_third.model.SignUpRequest;
import com.tenqube.visual_third.model.SignUpResponse;
import com.tenqube.visual_third.model.TransactionRequest;
import com.tenqube.visual_third.util.Mapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.Transaction;

class VisualApi {
    public static final String TAG = VisualApi.class.getSimpleName();
    public static VisualApi mInstance;
    private Context context;
    private VisualApiService visualApiService;
    private SearchApiService searchApiService;
    private PrefManager prefManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualApi getInstance(Context context) {
        Class<VisualApi> clazz = VisualApi.class;
        synchronized (VisualApi.class) {
            if (mInstance == null) {
                mInstance = new VisualApi(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualApi(Context context) {
        this.context = context;
        this.prefManager = PrefManager.getInstance(context);
    }

    private VisualApiService getApiService() {
        if (this.visualApiService == null) {
            this.visualApiService = (VisualApiService)this.provideRetrofit(this.getUrl(), false).create(VisualApiService.class);
        }
        return this.visualApiService;
    }

    private SearchApiService getSearchApiService() {
        if (this.searchApiService == null) {
            this.searchApiService = (SearchApiService)this.provideRetrofit(this.prefManager.loadStringValue("TENQUBE_SEARCH_URL", ""), true).create(SearchApiService.class);
        }
        return this.searchApiService;
    }

    private String getUrl() {
        return "https://clip.tenqube.kr/prod/";
    }

    private Retrofit provideRetrofit(String url, boolean isSearch) {
        return new Retrofit.Builder().baseUrl(url).client(this.provideOkHttpClient(isSearch)).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
    }

    private OkHttpClient provideOkHttpClient(boolean isSearch) {
        OkHttpClient.Builder okhttpClientBuilder = new OkHttpClient.Builder();
        okhttpClientBuilder.connectTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.readTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.writeTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.addInterceptor((Interceptor)(isSearch ? new AddSearchHeaderInterceptor(this.prefManager) : new AddHeaderInterceptor(this.prefManager)));
        return okhttpClientBuilder.build();
    }

    public void signUp(SignUpRequest signUpInfo, final OnResultListener listener) {
        Call<SignUpResponse> call = this.getApiService().signUp(signUpInfo);
        call.enqueue((Callback)new Callback<SignUpResponse>(){

            public void onResponse(Call<SignUpResponse> call, Response<SignUpResponse> response) {
                SignUpResponse signUpResponse;
                if (response.isSuccessful() && (signUpResponse = (SignUpResponse)response.body()) != null) {
                    VisualApi.this.prefManager.saveStringValue("TENQUBE_SEARCH_URL", signUpResponse.getResults().getSearch().getUrl());
                    VisualApi.this.prefManager.saveStringValue("TENQUBE_SEARCH_API_KEY", signUpResponse.getResults().getSearch().getApiKey());
                    VisualApi.this.prefManager.saveStringValue("TENQUBE_UID", signUpResponse.getResults().getAuthorization().getSdk());
                    VisualApi.this.prefManager.saveLongValue("TENQUBE_SIGN_UP_TIME", Calendar.getInstance().getTimeInMillis());
                    return;
                }
                listener.onSuccess(false);
            }

            public void onFailure(Call<SignUpResponse> call, Throwable t) {
                listener.onSuccess(false);
            }
        });
    }

    public ParsingRule syncParsingRule() {
        try {
            Response response = this.getApiService().syncParsingRule(this.prefManager.loadIntValue("TENQUBE_PARSING_RULE_VERSION", -1)).execute();
            if (response.isSuccessful()) {
                ParsingRule parsingRule = (ParsingRule)response.body();
                if (parsingRule != null) {
                    this.prefManager.saveIntValue("TENQUBE_PARSING_RULE_VERSION", parsingRule.ruleVersion);
                }
                return (ParsingRule)response.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SearchCompanyResponse searchCompany(ArrayList<Transaction> transactions) {
        try {
            Response response = this.getSearchApiService().searchCompany(new SearchCompanyRequest(Mapper.toSearchTransaction(transactions))).execute();
            if (response.isSuccessful()) {
                SearchCompanyResponse searchCompanyResponse = (SearchCompanyResponse)response.body();
                return searchCompanyResponse;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void searchCompany(ArrayList<Transaction> transactions, final OnNetworkResultListener callback) {
        Call<SearchCompanyResponse> call = this.getSearchApiService().searchCompany(new SearchCompanyRequest(Mapper.toSearchTransaction(transactions)));
        call.enqueue((Callback)new Callback<SearchCompanyResponse>(){

            public void onResponse(Call<SearchCompanyResponse> call, Response<SearchCompanyResponse> response) {
                SearchCompanyResponse searchCompanyResponse = (SearchCompanyResponse)response.body();
                if (callback != null) {
                    callback.onResult(true);
                }
            }

            public void onFailure(Call<SearchCompanyResponse> call, Throwable t) {
                if (callback != null) {
                    callback.onResult(false);
                }
            }
        });
    }

    public void saveTransactions(TransactionRequest transactionRequest, Callback<Void> callback) {
        Call<Void> call = this.getApiService().saveTransactions(transactionRequest);
        call.enqueue(callback);
    }
}

