

package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;


/**
 * Utilities and constants related to app preferences.
 */
public class PrefManager {

    private static final String TAG = PrefManager.class.getSimpleName();

    public static final String PREFIX = "TENQUBE_";

    public static final String PARSING_RULE_VERSION = PREFIX + "PARSING_RULE_VERSION";

    public static final String UID = PREFIX + "UID";

    public static final String SEARCH_URL = PREFIX + "SEARCH_URL";

    public static final String SEARCH_API_KEY = PREFIX + "SEARCH_API_KEY";

    public static final String BULK_EXECUTED = PREFIX + "BULK_EXECUTED";

    public static final String SIGN_UP_TIME = PREFIX + "SIGN_UP_TIME";



    private static PrefManager mInstance;
    private Context context;
    public  static PrefManager getInstance(Context context){
        synchronized (PrefManager.class) {
            if(mInstance == null){
                mInstance = new PrefManager(context.getApplicationContext());
            }

        }
        return mInstance;
    }

    private PrefManager(Context context){
        this.context = context;
    }


    public boolean isEnabled(String key, boolean defaultValue){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        return sp.getBoolean(key, defaultValue);
    }

    public void saveBoolean(String key, boolean flag){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        sp.edit().putBoolean(key, flag).apply();
    }

    public int loadIntValue(String key, int defaultValue){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        return sp.getInt(key, defaultValue);
    }

    public void saveIntValue(String key, int value){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        sp.edit().putInt(key, value).apply();
    }

    public float loadFloatValue(String key, float defaultValue){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        return sp.getFloat(key, defaultValue);
    }

    public void saveFloatValue(String key, float value){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        sp.edit().putFloat(key, value).apply();
    }

    public long loadLongValue(String key, long defaultValue){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        return sp.getLong(key, defaultValue);
    }

    public void saveLongValue(String key, long value){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        sp.edit().putLong(key, value).apply();
    }

    public String loadStringValue(String key, String defaultValue){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        return sp.getString(key, defaultValue);
    }

    public void saveStringValue(String key, String value){
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        sp.edit().putString(key, value).apply();
    }

}
