package com.tenqube.visual_third.parser.catcher;

import android.annotation.TargetApi;
import android.app.Notification;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;

import com.tenqube.visual_third.manager.PrefManager;

import tenqube.parser.model.SMS;

import static com.tenqube.visual_third.manager.PrefManager.ACCESS_NOTI_LISTENER;
import static com.tenqube.visual_third.util.Utils.getConvertedDate;
import static com.tenqube.visual_third.util.Utils.isSDKDisabled;

@TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
public class NotiCatcher extends NotificationListenerService {

    private String TAG = this.getClass().getSimpleName();

    @Override
    public IBinder onBind(Intent mIntent) {
        return super.onBind(mIntent);
    }

    @Override
    public boolean onUnbind(Intent mIntent) {
        return super.onUnbind(mIntent);
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @TargetApi(Build.VERSION_CODES.KITKAT)
    @Override
    public void onNotificationPosted(final StatusBarNotification sbn) {

        // 로그인 되지 않은경우
        if(isSDKDisabled(getApplicationContext()))
            return;

        new Thread(new Runnable() {
            @Override
            public void run() {
                parseNoti(sbn);
            }
        }).start();
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    private void parseNoti(StatusBarNotification sbn) {

        String packageName;
        String title = "none";
        String content = null;

        try {
            if (shouldParse(sbn)) {

                // 데이터 파싱  시작
                packageName = sbn.getPackageName();

                Notification notification = sbn.getNotification();

                CharSequence titleCS = notification.extras.getCharSequence(Notification.EXTRA_TITLE);
                CharSequence contentCS = notification.extras.getCharSequence(Notification.EXTRA_TEXT);

                if(titleCS != null) title = titleCS.toString();
                if(contentCS != null) content = contentCS.toString();

                long date = notification.when;

                if(isInValid(content, packageName)) return;


                // 슬랙, 행아웃 테스트 코드
                if("com.Slack".equals(packageName) || "com.google.android.talk". equals(packageName)) {

                    int startPos = content.indexOf("`");
                    content = content.substring(startPos + 1);
                    String[] contents = content.split(";");
                    if(contents.length == 3) {
                        packageName = contents[0].trim();
                        title = contents[1].trim();
                        content = contents[2].trim();
                    }
                }

                SMS sms = new SMS(0, content, packageName, packageName, getConvertedDate(date), tenqube.parser.constants.Constants.SMSType.NOTIFICATION.ordinal());
                sms.title = title;

                // 인텐트 서비스 시작
                Intent startIntent = new Intent(getApplicationContext(), SmsMmsService.class);
                startIntent.putExtra(SmsMmsService.ARG_SMS, sms);
                startService(startIntent);

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    private boolean shouldParse(StatusBarNotification sbn) {
        return sbn != null &&
                sbn.getNotification() != null &&
                sbn.getNotification().extras != null &&
                sbn.getNotification().extras.getInt(Notification.EXTRA_PROGRESS) == 0 &&
                sbn.getNotification().extras.getInt(Notification.EXTRA_PROGRESS_MAX) == 0;
    }

    private boolean isInValid(String content , String packageName) {

        return TextUtils.isEmpty(content) ||
                TextUtils.isEmpty(packageName) ||
                "me.kkebi.ting".equals(packageName) ||
                "com.android.systemui".equals(packageName) ||
                "com.tenqube.qlip".equals(packageName) ||
                "com.internet.speed.meter.lite".equals(packageName) ||
                "com.sec.android.app.clockpackage".equals(packageName) ||
                "wan.util.barclock".equals(packageName) ||
                "com.eclipsim.gpsstatus2".equals(packageName) ||
                "com.android.bluetooth".equals(packageName) ||
                "com.hyundai.ds".equals(packageName) ||
                "com.samsung.android.messaging".equals(packageName) ||
                "com.android.mms".equals(packageName);
    }

    @Override
    public void onNotificationRemoved(StatusBarNotification sbn) {

    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return START_REDELIVER_INTENT;
    }


    @Override
    public void onListenerConnected() {
        PrefManager.getInstance(this).saveBoolean(ACCESS_NOTI_LISTENER, true);
        super.onListenerConnected();
    }

    @Override
    public void onListenerDisconnected() {
        PrefManager.getInstance(this).saveBoolean(ACCESS_NOTI_LISTENER, false);
        super.onListenerDisconnected();
    }

}


