package com.tenqube.visual_third.entity;

import java.io.Serializable;

/**
 * 변경 사항 작성
 * 내용/변경자/날짜
 * ex) line 233 파라미터 추가 /사광진/2015-05-20
 *
 */
public class Currency implements Serializable {

    private final int currencyId;
    private final String from;
    private final String to;
    private final double rate;
    private final String createdAt;

    public Currency(int currencyId, String from, String to, double rate, String createdAt) {
        this.currencyId = currencyId;
        this.from = from;
        this.to = to;
        this.rate = rate;
        this.createdAt = createdAt;
    }

    public String insertValues() {
        return "(" +
                "'" +from + "'," +
                "'" + to + "'," +
                "" + rate + "," +
                "'" + createdAt + "')" ;
    }


    public int getCurrencyId() {
        return currencyId;
    }

    public String getFrom() {
        return from;
    }

    public String getTo() {
        return to;
    }

    public double getRate() {
        return rate;
    }

    public String getCreatedAt() {
        return createdAt;
    }
}

