/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdChoicesView;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.MediaView;
import com.facebook.ads.MediaViewListener;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeAdViewAttributes;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import java.util.ArrayList;
import java.util.Map;

@Keep
public final class FacebookAdapter
implements MediationBannerAdapter,
MediationInterstitialAdapter,
MediationRewardedVideoAdAdapter,
MediationNativeAdapter {
    public static final String KEY_AD_VIEW_ATTRIBUTES = "ad_view_attributes";
    public static final String KEY_AUTOPLAY = "autoplay";
    public static final String KEY_BACKGROUND_COLOR = "background_color";
    public static final String KEY_BUTTON_BORDER_COLOR = "button_border_color";
    public static final String KEY_BUTTON_COLOR = "button_color";
    public static final String KEY_BUTTON_TEXT_COLOR = "button_text_color";
    public static final String KEY_DESCRIPTION_TEXT_COLOR = "description_text_color";
    public static final String KEY_DESCRIPTION_TEXT_SIZE = "description_text_size";
    public static final String KEY_ID = "id";
    public static final String KEY_IS_BOLD = "is_bold";
    public static final String KEY_IS_ITALIC = "is_italic";
    public static final String KEY_SOCIAL_CONTEXT_ASSET = "social_context";
    public static final String KEY_STYLE = "style";
    public static final String KEY_SUBTITLE_ASSET = "subtitle";
    public static final String KEY_TITLE_TEXT_COLOR = "title_text_color";
    public static final String KEY_TITLE_TEXT_SIZE = "title_text_size";
    public static final String KEY_TYPEFACE = "typeface";
    private static final String PLACEMENT_PARAMETER = "pubid";
    private static final int MAX_STAR_RATING = 5;
    private static final String TAG = "FacebookAdapter";
    private MediationBannerListener mBannerListener;
    private MediationInterstitialListener mInterstitialListener;
    private MediationRewardedVideoAdListener mRewardedListener;
    private MediationNativeListener mNativeListener;
    private AdView mAdView;
    private RelativeLayout mWrappedAdView;
    private InterstitialAd mInterstitialAd;
    private String mPlacementId;
    private RewardedVideoAd mRewardedVideoAd;
    private Context mContext;
    private NativeAd mNativeAd;
    private boolean mIsInitialized;
    private boolean mIsImpressionRecorded;
    private boolean mIsAdChoicesIconExpandable = true;
    private MediaView mMediaView;

    public void onDestroy() {
        if (this.mAdView != null) {
            this.mAdView.destroy();
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
        }
        if (this.mNativeAd != null) {
            this.mNativeAd.unregisterView();
            this.mNativeAd.destroy();
        }
        if (this.mMediaView != null) {
            this.mMediaView.destroy();
        }
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.destroy();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void requestBannerAd(Context context, MediationBannerListener listener, Bundle serverParameters, com.google.android.gms.ads.AdSize adSize, MediationAdRequest adRequest, Bundle mediationExtras) {
        this.mBannerListener = listener;
        if (!FacebookAdapter.isValidRequestParameters(context, serverParameters)) {
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 1);
            return;
        }
        if (adSize == null) {
            Log.w((String)TAG, (String)"Fail to request banner ad, adSize is null");
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 1);
            return;
        }
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        AdSize facebookAdSize = this.getAdSize(context, adSize);
        if (facebookAdSize == null) {
            Log.w((String)TAG, (String)("The input ad size " + adSize.toString() + " is not supported at this moment."));
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 3);
            return;
        }
        AdSettings.setMediationService((String)("ADMOB_" + FacebookAdapter.getGMSVersionCode(context)));
        this.mAdView = new AdView(context, placementId, facebookAdSize);
        this.mAdView.setAdListener((AdListener)new BannerListener());
        this.buildAdRequest(adRequest);
        RelativeLayout.LayoutParams adViewLayoutParams = new RelativeLayout.LayoutParams(adSize.getWidthInPixels(context), adSize.getHeightInPixels(context));
        this.mWrappedAdView = new RelativeLayout(context);
        this.mAdView.setLayoutParams((ViewGroup.LayoutParams)adViewLayoutParams);
        this.mWrappedAdView.addView((View)this.mAdView);
        this.mAdView.loadAd();
    }

    public View getBannerView() {
        return this.mWrappedAdView;
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener listener, Bundle serverParameters, MediationAdRequest adRequest, Bundle mediationExtras) {
        this.mInterstitialListener = listener;
        if (!FacebookAdapter.isValidRequestParameters(context, serverParameters)) {
            this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, 1);
            return;
        }
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        AdSettings.setMediationService((String)("ADMOB_" + FacebookAdapter.getGMSVersionCode(context)));
        this.mInterstitialAd = new InterstitialAd(context, placementId);
        this.mInterstitialAd.setAdListener((InterstitialAdListener)new InterstitialListener());
        this.buildAdRequest(adRequest);
        this.mInterstitialAd.loadAd();
    }

    public void showInterstitial() {
        if (this.mInterstitialAd.isAdLoaded()) {
            this.mInterstitialAd.show();
        }
    }

    public void initialize(Context context, MediationAdRequest mediationAdRequest, String unused, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle serverParameters, Bundle networkExtras) {
        this.mContext = context;
        this.mRewardedListener = mediationRewardedVideoAdListener;
        if (!FacebookAdapter.isValidRequestParameters(context, serverParameters)) {
            this.mRewardedListener.onAdFailedToLoad((MediationRewardedVideoAdAdapter)this, 1);
            return;
        }
        this.mPlacementId = serverParameters.getString(PLACEMENT_PARAMETER);
        this.mIsInitialized = true;
        this.mRewardedListener.onInitializationSucceeded((MediationRewardedVideoAdAdapter)this);
    }

    public void loadAd(MediationAdRequest mediationAdRequest, Bundle serverParameters, Bundle networkExtras) {
        if (this.mRewardedVideoAd == null) {
            this.mRewardedVideoAd = new RewardedVideoAd(this.mContext, this.mPlacementId);
            this.mRewardedVideoAd.setAdListener((RewardedVideoAdListener)new RewardedVideoListener());
        }
        if (this.mRewardedVideoAd.isAdLoaded()) {
            this.mRewardedListener.onAdLoaded((MediationRewardedVideoAdAdapter)this);
        } else {
            this.buildAdRequest(mediationAdRequest);
            AdSettings.setMediationService((String)("ADMOB_" + FacebookAdapter.getGMSVersionCode(this.mContext)));
            this.mRewardedVideoAd.loadAd(true);
        }
    }

    public void showVideo() {
        if (this.mRewardedVideoAd != null && this.mRewardedVideoAd.isAdLoaded()) {
            this.mRewardedVideoAd.show();
            this.mRewardedListener.onAdOpened((MediationRewardedVideoAdAdapter)this);
            this.mRewardedListener.onVideoStarted((MediationRewardedVideoAdAdapter)this);
        } else {
            Log.w((String)TAG, (String)"No ads to show.");
            if (this.mRewardedListener != null) {
                this.mRewardedListener.onAdOpened((MediationRewardedVideoAdAdapter)this);
                this.mRewardedListener.onAdClosed((MediationRewardedVideoAdAdapter)this);
            }
        }
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void requestNativeAd(Context context, MediationNativeListener listener, Bundle serverParameters, NativeMediationAdRequest mediationAdRequest, Bundle mediationExtras) {
        this.mNativeListener = listener;
        if (!FacebookAdapter.isValidRequestParameters(context, serverParameters)) {
            this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
            return;
        }
        if (!mediationAdRequest.isAppInstallAdRequested() || !mediationAdRequest.isContentAdRequested()) {
            Log.w((String)TAG, (String)"Failed to request native ad. Both app install and content ad should be requested");
            this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
            return;
        }
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        if (mediationExtras != null) {
            this.mIsAdChoicesIconExpandable = mediationExtras.getBoolean("expandable_icon", true);
        }
        this.mMediaView = new MediaView(context);
        AdSettings.setMediationService((String)("ADMOB_" + FacebookAdapter.getGMSVersionCode(context)));
        this.mNativeAd = new NativeAd(context, placementId);
        this.mNativeAd.setAdListener((NativeAdListener)new NativeListener(this.mNativeAd, mediationAdRequest));
        this.buildAdRequest((MediationAdRequest)mediationAdRequest);
        this.mNativeAd.loadAd();
    }

    private static boolean isValidRequestParameters(Context context, Bundle serverParameters) {
        if (context == null) {
            Log.w((String)TAG, (String)"Failed to request ad, Context is null.");
            return false;
        }
        if (serverParameters == null) {
            Log.w((String)TAG, (String)"Failed to request ad, serverParameters is null.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)serverParameters.getString(PLACEMENT_PARAMETER))) {
            Log.w((String)TAG, (String)"Failed to request ad, placementId is null or empty.");
            return false;
        }
        return true;
    }

    private int convertErrorCode(AdError adError) {
        if (adError == null) {
            return 0;
        }
        int errorCode = adError.getErrorCode();
        switch (errorCode) {
            case 1000: 
            case 2000: {
                return 2;
            }
            case 1001: {
                return 3;
            }
            case 1002: {
                return 1;
            }
        }
        return 0;
    }

    private void buildAdRequest(MediationAdRequest adRequest) {
        if (adRequest != null) {
            AdSettings.setIsChildDirected((adRequest.taggedForChildDirectedTreatment() == 1 ? 1 : 0) != 0);
        }
    }

    private AdSize getAdSize(Context context, com.google.android.gms.ads.AdSize adSize) {
        if (adSize.getWidth() == AdSize.BANNER_320_50.getWidth() && adSize.getHeight() == AdSize.BANNER_320_50.getHeight()) {
            return AdSize.BANNER_320_50;
        }
        int heightInDip = this.pixelToDip(adSize.getHeightInPixels(context));
        if (heightInDip == AdSize.BANNER_HEIGHT_50.getHeight()) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (heightInDip == AdSize.BANNER_HEIGHT_90.getHeight()) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (heightInDip == AdSize.RECTANGLE_HEIGHT_250.getHeight()) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        return null;
    }

    private int pixelToDip(int pixel) {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return Math.round((float)pixel / displayMetrics.density);
    }

    private static int getGMSVersionCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)"com.google.android.gms", (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return 0;
        }
    }

    private static interface NativeAdMapperListener {
        public void onMappingSuccess();

        public void onMappingFailed();
    }

    private class FacebookAdapterNativeAdImage
    extends NativeAd.Image {
        private Drawable mDrawable;
        private Uri mUri;

        public FacebookAdapterNativeAdImage(Uri uri) {
            this.mUri = uri;
        }

        protected void setDrawable(Drawable drawable2) {
            this.mDrawable = drawable2;
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public double getScale() {
            return 1.0;
        }
    }

    public static class FacebookExtrasBundleBuilder {
        private static final String KEY_EXPANDABLE_ICON = "expandable_icon";
        private boolean mIsExpandableIcon;

        public FacebookExtrasBundleBuilder setNativeAdChoicesIconExpandable(boolean isExpandableIcon) {
            this.mIsExpandableIcon = isExpandableIcon;
            return this;
        }

        public Bundle build() {
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_EXPANDABLE_ICON, this.mIsExpandableIcon);
            return bundle;
        }
    }

    class AppInstallMapper
    extends NativeAppInstallAdMapper {
        private NativeAd mNativeAd;
        private NativeAdOptions mNativeAdOptions;

        public AppInstallMapper(NativeAd nativeAd, NativeAdOptions adOptions) {
            this.mNativeAd = nativeAd;
            this.mNativeAdOptions = adOptions;
        }

        public void mapNativeAd(NativeAdMapperListener mapperListener) {
            if (!this.containsRequiredFieldsForNativeAppInstallAd(this.mNativeAd)) {
                Log.w((String)FacebookAdapter.TAG, (String)"Ad from Facebook doesn't have all assets required for the app install format.");
                mapperListener.onMappingFailed();
                return;
            }
            this.setHeadline(this.mNativeAd.getAdHeadline());
            ArrayList<FacebookAdapterNativeAdImage> images = new ArrayList<FacebookAdapterNativeAdImage>();
            images.add(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeAd.getAdCoverImage().toString())));
            this.setImages(images);
            this.setBody(this.mNativeAd.getAdBodyText());
            this.setIcon(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeAd.getAdIcon().toString())));
            this.setCallToAction(this.mNativeAd.getAdCallToAction());
            FacebookAdapter.this.mMediaView.setListener(new MediaViewListener(){

                public void onPlay(MediaView mediaView) {
                }

                public void onVolumeChange(MediaView mediaView, float v) {
                }

                public void onPause(MediaView mediaView) {
                }

                public void onComplete(MediaView mediaView) {
                    if (FacebookAdapter.this.mNativeListener != null) {
                        FacebookAdapter.this.mNativeListener.onVideoEnd((MediationNativeAdapter)FacebookAdapter.this);
                    }
                }

                public void onEnterFullscreen(MediaView mediaView) {
                }

                public void onExitFullscreen(MediaView mediaView) {
                }

                public void onFullscreenBackground(MediaView mediaView) {
                }

                public void onFullscreenForeground(MediaView mediaView) {
                }
            });
            this.setMediaView((View)FacebookAdapter.this.mMediaView);
            this.setHasVideoContent(true);
            Double starRating = this.getRating(this.mNativeAd.getAdStarRating());
            if (starRating != null) {
                this.setStarRating(starRating);
            }
            Bundle extras = new Bundle();
            extras.putCharSequence(FacebookAdapter.KEY_ID, (CharSequence)this.mNativeAd.getId());
            extras.putCharSequence(FacebookAdapter.KEY_SOCIAL_CONTEXT_ASSET, (CharSequence)this.mNativeAd.getAdSocialContext());
            NativeAdViewAttributes attributes = this.mNativeAd.getAdViewAttributes();
            if (attributes != null) {
                Bundle attributesBundle = new Bundle();
                attributesBundle.putBoolean(FacebookAdapter.KEY_AUTOPLAY, attributes.getAutoplay());
                attributesBundle.putInt(FacebookAdapter.KEY_BACKGROUND_COLOR, attributes.getBackgroundColor());
                attributesBundle.putInt(FacebookAdapter.KEY_BUTTON_BORDER_COLOR, attributes.getButtonBorderColor());
                attributesBundle.putInt(FacebookAdapter.KEY_BUTTON_COLOR, attributes.getButtonColor());
                attributesBundle.putInt(FacebookAdapter.KEY_BUTTON_TEXT_COLOR, attributes.getButtonTextColor());
                attributesBundle.putInt(FacebookAdapter.KEY_DESCRIPTION_TEXT_COLOR, attributes.getDescriptionTextColor());
                attributesBundle.putInt(FacebookAdapter.KEY_DESCRIPTION_TEXT_SIZE, attributes.getDescriptionTextSize());
                attributesBundle.putInt(FacebookAdapter.KEY_TITLE_TEXT_COLOR, attributes.getTitleTextColor());
                attributesBundle.putInt(FacebookAdapter.KEY_TITLE_TEXT_SIZE, attributes.getTitleTextSize());
                Typeface typeface = attributes.getTypeface();
                if (typeface != null) {
                    Bundle typefaceBundle = new Bundle();
                    typefaceBundle.putBoolean(FacebookAdapter.KEY_IS_BOLD, typeface.isBold());
                    typefaceBundle.putBoolean(FacebookAdapter.KEY_IS_ITALIC, typeface.isItalic());
                    typefaceBundle.putInt(FacebookAdapter.KEY_STYLE, typeface.getStyle());
                    attributesBundle.putBundle(FacebookAdapter.KEY_TYPEFACE, typefaceBundle);
                }
                extras.putBundle(FacebookAdapter.KEY_AD_VIEW_ATTRIBUTES, attributesBundle);
            }
            this.setExtras(extras);
            mapperListener.onMappingSuccess();
        }

        private boolean containsRequiredFieldsForNativeAppInstallAd(NativeAd nativeAd) {
            return nativeAd.getAdHeadline() != null && nativeAd.getAdCoverImage() != null && nativeAd.getAdBodyText() != null && nativeAd.getAdIcon() != null && nativeAd.getAdCallToAction() != null && FacebookAdapter.this.mMediaView != null;
        }

        public void trackViews(View view, Map<String, View> clickableAssetViews, Map<String, View> nonClickableAssetViews) {
            AdChoicesView adChoicesView;
            ViewGroup adView = (ViewGroup)view;
            View overlayView = adView.getChildAt(adView.getChildCount() - 1);
            if (overlayView instanceof FrameLayout) {
                adChoicesView = new AdChoicesView(view.getContext(), (NativeAdBase)this.mNativeAd, FacebookAdapter.this.mIsAdChoicesIconExpandable);
                ((ViewGroup)overlayView).addView((View)adChoicesView);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)adChoicesView.getLayoutParams();
                if (this.mNativeAdOptions != null) {
                    switch (this.mNativeAdOptions.getAdChoicesPlacement()) {
                        case 0: {
                            params.gravity = 51;
                            break;
                        }
                        case 2: {
                            params.gravity = 85;
                            break;
                        }
                        case 3: {
                            params.gravity = 83;
                            break;
                        }
                        default: {
                            params.gravity = 53;
                            break;
                        }
                    }
                } else {
                    params.gravity = 53;
                }
                adView.requestLayout();
            } else {
                adChoicesView = new AdChoicesView(view.getContext(), (NativeAdBase)this.mNativeAd, FacebookAdapter.this.mIsAdChoicesIconExpandable);
                this.setAdChoicesContent((View)adChoicesView);
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            ImageView iconview = null;
            ArrayList<View> assetViews = new ArrayList<View>();
            for (Map.Entry<String, View> clickableAssets : clickableAssetViews.entrySet()) {
                assetViews.add(clickableAssets.getValue());
                if (!clickableAssets.getKey().equals("2003") && !clickableAssets.getKey().equals("3003")) continue;
                iconview = (ImageView)clickableAssets.getValue();
            }
            this.mNativeAd.registerViewForInteraction(view, FacebookAdapter.this.mMediaView, iconview, assetViews);
        }

        public void untrackView(View view) {
            super.untrackView(view);
            ViewGroup adView = (ViewGroup)view;
            View overlayView = adView.getChildAt(adView.getChildCount() - 1);
            if (overlayView instanceof FrameLayout) {
                ((FrameLayout)overlayView).removeAllViews();
            }
            this.mNativeAd.unregisterView();
        }

        private Double getRating(NativeAdBase.Rating rating) {
            if (rating == null) {
                return null;
            }
            return 5.0 * rating.getValue() / rating.getScale();
        }
    }

    private class NativeListener
    implements AdListener,
    NativeAdListener {
        private NativeAd mNativeAd;
        private NativeMediationAdRequest mMediationAdRequest;

        private NativeListener(NativeAd nativeAd, NativeMediationAdRequest mediationAdRequest) {
            this.mNativeAd = nativeAd;
            this.mMediationAdRequest = mediationAdRequest;
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mNativeListener.onAdClicked((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdOpened((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdLeftApplication((MediationNativeAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
            if (FacebookAdapter.this.mIsImpressionRecorded) {
                Log.d((String)FacebookAdapter.TAG, (String)"Received onLoggingImpression callback for a native whose impression is already recorded. Ignoring the duplicate callback.");
                return;
            }
            FacebookAdapter.this.mNativeListener.onAdImpression((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mIsImpressionRecorded = true;
        }

        public void onAdLoaded(Ad ad) {
            if (ad != this.mNativeAd) {
                Log.w((String)FacebookAdapter.TAG, (String)"Ad loaded is not a native ad.");
                FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 0);
                return;
            }
            NativeAdOptions options = this.mMediationAdRequest.getNativeAdOptions();
            final AppInstallMapper mapper = new AppInstallMapper(this.mNativeAd, options);
            mapper.mapNativeAd(new NativeAdMapperListener(){

                @Override
                public void onMappingSuccess() {
                    FacebookAdapter.this.mNativeListener.onAdLoaded((MediationNativeAdapter)FacebookAdapter.this, (NativeAdMapper)mapper);
                }

                @Override
                public void onMappingFailed() {
                    FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 3);
                }
            });
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }

        public void onMediaDownloaded(Ad ad) {
            Log.d((String)FacebookAdapter.TAG, (String)"onMediaDownloaded");
        }
    }

    private class FacebookReward
    implements RewardItem {
        private FacebookReward() {
        }

        public String getType() {
            return "";
        }

        public int getAmount() {
            return 1;
        }
    }

    private class RewardedVideoListener
    implements RewardedVideoAdListener {
        private RewardedVideoListener() {
        }

        public void onRewardedVideoCompleted() {
            FacebookAdapter.this.mRewardedListener.onVideoCompleted((MediationRewardedVideoAdAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mRewardedListener.onRewarded((MediationRewardedVideoAdAdapter)FacebookAdapter.this, (RewardItem)new FacebookReward());
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mRewardedListener.onAdFailedToLoad((MediationRewardedVideoAdAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mRewardedListener.onAdLoaded((MediationRewardedVideoAdAdapter)FacebookAdapter.this);
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mRewardedListener.onAdClicked((MediationRewardedVideoAdAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mRewardedListener.onAdLeftApplication((MediationRewardedVideoAdAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
        }

        public void onRewardedVideoClosed() {
            FacebookAdapter.this.mRewardedListener.onAdClosed((MediationRewardedVideoAdAdapter)FacebookAdapter.this);
        }
    }

    private class InterstitialListener
    implements InterstitialAdListener {
        private InterstitialListener() {
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdClicked((MediationInterstitialAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mInterstitialListener.onAdLeftApplication((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdLoaded((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }

        public void onInterstitialDismissed(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdClosed((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onInterstitialDisplayed(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdOpened((MediationInterstitialAdapter)FacebookAdapter.this);
        }
    }

    private class BannerListener
    implements AdListener {
        private BannerListener() {
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdClicked((MediationBannerAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mBannerListener.onAdOpened((MediationBannerAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mBannerListener.onAdLeftApplication((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdLoaded((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }
    }
}

