/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.BitmapImageViewTarget;
import com.bumptech.glide.request.target.Target;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.entity.Advertisement;
import com.tenqube.visual_third.manager.FacebookAdapter;
import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

public class AdManager {
    public static final String AD_ID = "ca-app-pub-1003660361092577~4657260383";
    public static final String UNIT_ID = "ca-app-pub-1003660361092577/4309119488";
    public static final String TEST_UNIT_ID = "ca-app-pub-3940256099942544/2247696110";
    private static AdManager mInstance = null;
    private VisualRepository repository;
    private VisualApi callApi;
    private Context mContext;
    private View defaultView;
    private View adContainer;
    private UnifiedNativeAdView mAdView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdManager getInstance(Context ctx) {
        Class<AdManager> clazz = AdManager.class;
        synchronized (AdManager.class) {
            if (mInstance == null) {
                mInstance = new AdManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private AdManager(Context context) {
        this.mContext = context;
        MobileAds.initialize((Context)context.getApplicationContext(), (String)AD_ID);
        this.callApi = VisualApi.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
    }

    public void loadAd(@NonNull OnAdLoadedListener listener) {
        this.loadVisualAd(listener);
    }

    private void loadVisualAd(final OnAdLoadedListener listener) {
        try {
            AdResponse adResponse;
            String[] authInfos = this.callApi.getAuthInfo();
            VersionResponse versionResponse = this.callApi.syncVersion(authInfos[0]);
            int version = this.repository.loadAdVersion();
            if (versionResponse != null && versionResponse.getAd() > version && (adResponse = this.callApi.getAds(versionResponse.getAd(), authInfos[0])) != null) {
                this.defaultView = null;
                this.repository.mergeAdvertisement(adResponse, versionResponse.getAd());
            }
            ArrayList<Advertisement> ads = this.repository.loadAds();
            final ArrayList<Advertisement> satisfiedAds = new ArrayList<Advertisement>();
            int priority = -1;
            for (Advertisement ad : ads) {
                if (priority != -1 && priority != ad.getPriority()) break;
                boolean isSatisfied = this.repository.isSatisfied(ad.getQuery());
                if (isSatisfied) {
                    satisfiedAds.add(ad);
                }
                priority = ad.getPriority();
            }
            new Handler(this.mContext.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (!satisfiedAds.isEmpty()) {
                        Advertisement advertisement = (Advertisement)satisfiedAds.get(Utils.getRandomNumber(satisfiedAds.size()));
                        AdManager.this.populateView(advertisement);
                        listener.onAdLoaded(AdManager.this.adContainer);
                    } else {
                        if (AdManager.this.mAdView == null) {
                            AdManager.this.loadGoogleAd(listener);
                        } else {
                            listener.onAdLoaded((View)AdManager.this.mAdView);
                        }
                        AdManager.this.loadGoogleAd(null);
                    }
                }
            });
        }
        catch (Exception e) {
            this.loadGoogleAd(listener);
        }
    }

    private void populateView(final @NonNull Advertisement advertisement) {
        this.adContainer = LayoutInflater.from((Context)this.mContext).inflate(R.layout.ad_view, null, false);
        this.setBgColor(this.adContainer, advertisement.getColors().getBgColor());
        ImageView imageTextView = (ImageView)this.adContainer.findViewById(R.id.image);
        RelativeLayout adTextContainer = (RelativeLayout)this.adContainer.findViewById(R.id.ad_text_container);
        this.adContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AdManager.this.goIntent(advertisement);
            }
        });
        if (!TextUtils.isEmpty((CharSequence)advertisement.getImage())) {
            imageTextView.setVisibility(0);
            Glide.with((Context)this.mContext).load(advertisement.getImage()).into(imageTextView);
            adTextContainer.setVisibility(8);
        } else {
            imageTextView.setVisibility(8);
            adTextContainer.setVisibility(0);
            ImageView iconImageView = (ImageView)this.adContainer.findViewById(R.id.icon_image);
            Glide.with((Context)this.mContext).load(advertisement.getIconImage()).into(iconImageView);
            TextView labelTextView = (TextView)this.adContainer.findViewById(R.id.label);
            labelTextView.setText((CharSequence)advertisement.getLabel());
            this.setTextColor(labelTextView, advertisement.getColors().getLabelColor());
            TextView titleTextView = (TextView)this.adContainer.findViewById(R.id.title);
            titleTextView.setText((CharSequence)advertisement.getTitle());
            this.setTextColor(titleTextView, advertisement.getColors().getTitleColor());
            TextView contentTextView = (TextView)this.adContainer.findViewById(R.id.content);
            contentTextView.setText((CharSequence)advertisement.getContent());
            this.setTextColor(contentTextView, advertisement.getColors().getContentColor());
            TextView linktoTextView = (TextView)this.adContainer.findViewById(R.id.linkto);
            linktoTextView.setText((CharSequence)advertisement.getLinkToStr());
            this.setTextColor(linktoTextView, advertisement.getColors().getLinkToColor());
        }
    }

    private void populateUnifiedNativeAdView(UnifiedNativeAd nativeAd, UnifiedNativeAdView adView) {
        String bgColor = this.repository.getAdmobColor("TENQUBE_ADMOB_BG_COLOR");
        String titleColor = this.repository.getAdmobColor("TENQUBE_ADMOB_TITLE_COLOR");
        String contentColor = this.repository.getAdmobColor("TENQUBE_ADMOB_CONTENT_COLOR");
        String labelColor = this.repository.getAdmobColor("TENQUBE_ADMOB_LABEL_COLOR");
        String linkToColor = this.repository.getAdmobColor("TENQUBE_ADMOB_LINK_COLOR");
        this.setBgColor((View)adView, bgColor);
        TextView labelTextView = (TextView)adView.findViewById(R.id.label);
        this.setTextColor(labelTextView, labelColor);
        adView.setHeadlineView(adView.findViewById(R.id.title));
        adView.setIconView(adView.findViewById(R.id.icon_image));
        adView.setBodyView(adView.findViewById(R.id.content));
        adView.setCallToActionView(adView.findViewById(R.id.linkto));
        ((TextView)adView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
        this.setTextColor((TextView)adView.getHeadlineView(), titleColor);
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(4);
        } else {
            adView.getBodyView().setVisibility(0);
            ((TextView)adView.getBodyView()).setText((CharSequence)nativeAd.getBody());
            this.setTextColor((TextView)adView.getBodyView(), contentColor);
        }
        if (nativeAd.getCallToAction() == null) {
            adView.getCallToActionView().setVisibility(4);
        } else {
            adView.getCallToActionView().setVisibility(0);
            ((TextView)adView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
            this.setTextColor((TextView)adView.getCallToActionView(), linkToColor);
        }
        if (nativeAd.getIcon() == null) {
            adView.getIconView().setVisibility(8);
        } else {
            ((ImageView)adView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(0);
        }
        adView.setNativeAd(nativeAd);
    }

    private void loadGoogleAd(final OnAdLoadedListener listener) {
        AdLoader.Builder builder = new AdLoader.Builder(this.mContext, UNIT_ID);
        builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                UnifiedNativeAdView adView = (UnifiedNativeAdView)LayoutInflater.from((Context)AdManager.this.mContext).inflate(R.layout.admob_view, null);
                AdManager.this.populateUnifiedNativeAdView(unifiedNativeAd, adView);
                if (listener != null) {
                    listener.onAdLoaded((View)adView);
                    AdManager.this.mAdView = null;
                } else {
                    AdManager.this.mAdView = adView;
                }
            }
        });
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
        builder.withNativeAdOptions(adOptions);
        AdLoader adLoader = builder.withAdListener(new AdListener(){

            public void onAdFailedToLoad(int errorCode) {
                AdManager.this.mAdView = null;
                if (AdManager.this.defaultView == null) {
                    AdManager.this.loadDefaultAd();
                }
                if (listener != null) {
                    listener.onAdLoaded(AdManager.this.defaultView);
                }
            }
        }).build();
        Bundle extras = new FacebookAdapter.FacebookExtrasBundleBuilder().build();
        AdRequest nativeAdRequest = new AdRequest.Builder().addNetworkExtrasBundle(FacebookAdapter.class, extras).build();
        adLoader.loadAd(nativeAdRequest);
    }

    private void loadDefaultAd() {
        Advertisement defaultAd = this.repository.loadAd(0);
        if (defaultAd == null) {
            AdResponse.Admob colors = new AdResponse.Admob("#ceaae0", "#ffffff", "#ffffff", "#ffffff", "#ffffff");
            defaultAd = new Advertisement(0, "", "\uad11\uace0", "", "visual", "app", "", "http://images.myqlip.com/banner.webp", "", 1, "", colors);
        }
        this.defaultView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.ad_default_view, null, false);
        final Advertisement finalDefaultAd = defaultAd;
        this.defaultView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AdManager.this.goIntent(finalDefaultAd);
            }
        });
        final ImageView imageView = (ImageView)this.defaultView.findViewById(R.id.image);
        Glide.with((Context)this.mContext).load(defaultAd.getImage()).asBitmap().into((Target)new BitmapImageViewTarget(imageView){

            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                imageView.setImageResource(R.drawable.banner);
            }
        });
    }

    private void goIntent(Advertisement ad) {
        try {
            if ("app".equals(ad.getLinkToType())) {
                VisualWebActivity.startActivity(this.mContext, "");
            } else if ("market".equals(ad.getLinkToType())) {
                GoOpenMarketUtil.openOnGooglePlayMarket(this.mContext, ad.getLinkTo());
            } else if ("web".equals(ad.getLinkToType())) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)ad.getLinkTo()));
                this.mContext.startActivity(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBgColor(View view, String bgColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)bgColor)) {
                view.setBackgroundResource(R.drawable.round);
                GradientDrawable drawable2 = (GradientDrawable)view.getBackground();
                drawable2.setColor(Color.parseColor((String)bgColor));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTextColor(TextView view, String textColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)textColor)) {
                view.setTextColor(Color.parseColor((String)textColor));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

