/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.ClipCategory;
import com.tenqube.visual_third.entity.Transaction;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.parser.PopupData;
import com.tenqube.visual_third.model.parser.TransactionData;
import com.tenqube.visual_third.parser.loader.BaseLoader;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.util.LogUtil;

public class OneLoader
extends BaseLoader {
    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private AdManager adManager;
    private int mServerCnt = 0;

    private OneLoader(Context context) {
        super(context);
        this.adManager = AdManager.getInstance(context);
    }

    public synchronized void doParsing(final SMS sms) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogUtil.LOGI((String)TAG, (String)("doParsing" + sms.toString()), (boolean)ParserService.mIsDebug);
                ParserResult parserResult = OneLoader.this.parserService.parse(sms);
                if (parserResult.resultCode != 1 && "com.samsung.android.spay".equals(sms.sender)) {
                    sms.fullSms = sms.title;
                    parserResult = OneLoader.this.parserService.parse(sms);
                }
                LogUtil.LOGI((String)TAG, (String)("parserResult" + parserResult.resultCode + ResultCode.stringValueOf((Integer)parserResult.resultCode)), (boolean)ParserService.mIsDebug);
                switch (parserResult.resultCode) {
                    case -4: {
                        OneLoader.this.syncParsingRule();
                        break;
                    }
                    case -6: {
                        if (!Utils.shouldParsing(sms.fullSms)) break;
                        OneLoader.this.syncParsingRuleAndNoSender();
                        break;
                    }
                    case -5: {
                        break;
                    }
                    case 1: {
                        OneLoader.this.parsedSMS(parserResult.transactions);
                    }
                }
            }
        }).start();
    }

    private void syncParsingRuleAndNoSender() {
        ++this.mServerCnt;
        if (this.mServerCnt == 10) {
            this.mServerCnt = 0;
            this.syncParsingRule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneLoader getInstance(Context context) {
        Class<OneLoader> clazz = OneLoader.class;
        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private void parsedSMS(ArrayList<tenqube.parser.model.Transaction> parsedTransactions) {
        try {
            Object category;
            ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions = Mapper.toParserTransactions(parsedTransactions);
            final com.tenqube.visual_third.model.parser.Transaction currentTran = this.getCurrentTransaction(transactions);
            if (currentTran == null) {
                return;
            }
            this.addLocationInfo(currentTran);
            this.setCurrency(transactions);
            this.repository.mergeTransactions(transactions);
            final int tranId = this.repository.loadTranId(currentTran.getParsedTransaction().identifier);
            if (tranId == 0) {
                return;
            }
            Transaction applyAllTran = this.repository.loadApplyAllTran(currentTran.getParsedTransaction().keyword);
            SearchCompanyResponse searchCompanyResponse = null;
            if (applyAllTran != null) {
                ArrayList<SearchCompanyResponse.TranCompany> results = new ArrayList<SearchCompanyResponse.TranCompany>();
                SearchCompanyResponse.Company company = new SearchCompanyResponse.Company(applyAllTran.getCompanyId(), applyAllTran.getFranchise(), "");
                category = new SearchCompanyResponse.Category(applyAllTran.getCategoryCode() + "");
                SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(applyAllTran.getKeyword(), applyAllTran.getSearchKeyword());
                SearchCompanyResponse.TranCompany tranCompany = new SearchCompanyResponse.TranCompany("" + applyAllTran.getIdentifier(), applyAllTran.getClassCode(), company, (SearchCompanyResponse.Category)category, keyword);
                results.add(tranCompany);
                searchCompanyResponse = new SearchCompanyResponse(results);
            } else {
                ArrayList<SearchCompanyRequest.Transaction> apiTransactions = Mapper.toSearchTransaction(transactions);
                if (!Utils.isEmpty(apiTransactions)) {
                    searchCompanyResponse = this.api.searchCompany(new SearchCompanyRequest(apiTransactions));
                }
                if (searchCompanyResponse == null) {
                    ArrayList<SearchCompanyResponse.TranCompany> results = new ArrayList<SearchCompanyResponse.TranCompany>();
                    boolean isWithdraw = currentTran.getParsedTransaction().dwType == Constants.DWType.WITHDRAW.ordinal();
                    SearchCompanyResponse.Company company = new SearchCompanyResponse.Company(isWithdraw ? 1260117 : 3983462, "'\ubbf8\ubd84\ub958'", "");
                    SearchCompanyResponse.Category category2 = new SearchCompanyResponse.Category(isWithdraw ? "101010" : "901010");
                    SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(currentTran.getParsedTransaction().keyword, currentTran.getParsedTransaction().keyword);
                    SearchCompanyResponse.TranCompany tranCompany = new SearchCompanyResponse.TranCompany("" + currentTran.getParsedTransaction().identifier, "NF", company, category2, keyword);
                    results.add(tranCompany);
                    searchCompanyResponse = new SearchCompanyResponse(results);
                }
            }
            this.repository.updateTransactions(searchCompanyResponse);
            if (currentTran.getParsedTransaction().isDuplicate == 0) {
                final SearchCompanyResponse.TranCompany searchedCompany = this.findSearchedCompany(searchCompanyResponse, currentTran.getParsedTransaction());
                String categoryCode = currentTran.getCategoryCode();
                if (searchedCompany != null) {
                    categoryCode = searchedCompany.getCategory().getCode();
                }
                if ((category = this.repository.loadCategory(categoryCode)) == null) {
                    return;
                }
                ClipCategory clipCategory = this.repository.loadClipCategory(categoryCode);
                if (clipCategory == null) {
                    clipCategory = new ClipCategory(1, ((Category)category).getCode(), "\uae30\ud0c0", "CRDCTG100009");
                }
                ClipCategory finalClipCategory = clipCategory;
                this.adManager.loadAd(new OnAdLoadedListener((Category)category, finalClipCategory){
                    final /* synthetic */ Category val$category;
                    final /* synthetic */ ClipCategory val$finalClipCategory;
                    {
                        this.val$category = category;
                        this.val$finalClipCategory = clipCategory;
                    }

                    @Override
                    public void onAdLoaded(View view) {
                        OneLoader.this.startTranPopup(tranId, currentTran, searchedCompany, this.val$category, this.val$finalClipCategory, view);
                    }
                });
            }
            this.api.syncTransactions(null);
            LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(new Intent("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED"));
            VisualAlarmManager.getInstance(this.mContext).setAlarms();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private com.tenqube.visual_third.model.parser.Transaction getCurrentTransaction(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {
        for (com.tenqube.visual_third.model.parser.Transaction transaction : transactions) {
            if (!transaction.getParsedTransaction().isCurrentTran) continue;
            return transaction;
        }
        return null;
    }

    private void addLocationInfo(com.tenqube.visual_third.model.parser.Transaction currentTran) {
        currentTran.getParsedTransaction().spentLatitude = -1.0;
        currentTran.getParsedTransaction().spentLongitude = -1.0;
    }

    private SearchCompanyResponse.TranCompany findSearchedCompany(SearchCompanyResponse searchCompanyResponse, tenqube.parser.model.Transaction currentTran) {
        SearchCompanyResponse.TranCompany searchedCompany = null;
        for (SearchCompanyResponse.TranCompany company : searchCompanyResponse.getResults()) {
            if (!company.getIdentifier().equals(currentTran.identifier)) continue;
            searchedCompany = company;
            break;
        }
        return searchedCompany;
    }

    private void startTranPopup(final int tranId, final com.tenqube.visual_third.model.parser.Transaction currentTran, final SearchCompanyResponse.TranCompany company, final Category category, final ClipCategory clipCategory, final View adView) {
        new Handler(this.mContext.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionData transactionData = new TransactionData(tranId, currentTran, company, category, clipCategory);
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("popup_data", (Serializable)new PopupData(transactionData, adView));
                    Intent intent = new Intent("tenqube.intent.action.ACTION_TRAN_POPUP");
                    intent.putExtra("popup_data", bundle);
                    LocalBroadcastManager.getInstance((Context)OneLoader.this.mContext).sendBroadcast(intent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

