package com.tenqube.visual_third.model;

import android.text.TextUtils;

import java.io.Serializable;

import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.util.Utils.threeComma;

public class TransactionPopupInfo implements Serializable{

    private Transaction transaction;
    private Company company;


    public TransactionPopupInfo(Transaction transaction, Company company) {
        this.transaction = transaction;
        this.company = company;
    }

    public String getCompanyTitle() {
        return company == null ? "" : company.getCompanyTitle();
    }

    public String getCompanyAddress() {
        return company == null ? "" : company.getCompanyAddress();
    }

    public String getSpentDate() {
        return transaction == null ? "" : transaction.spentDate;
    }


    public String getPayment() {
        if(transaction == null) return "";

        String payment = transaction.cardName;
        if(!TextUtils.isEmpty(transaction.cardNum)) {
            payment += " " + transaction.cardNum;
        }
        return payment;
    }


    public int getInstallmentCnt() {
        return transaction == null ? 1 :transaction.installmentCount;
    }

    public String getInstallmentStr() {
        int instCnt = getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "일시불" : instCnt + "개월";
    }

    public double getSpentMoney() {
        if(transaction == null) return 0;

        return transaction.spentMoney;
    }


    public String getSpentMoneyStr() {
        return threeComma(getSpentMoney());
    }

}
