package com.tenqube.visual_third.core;

import android.support.annotation.NonNull;

import com.tenqube.visual_third.BuildConfig;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class AddHeaderInterceptor implements Interceptor {
    AddHeaderInterceptor() {
    }

    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Request mainRequest = chain.request();
        Request.Builder builder = mainRequest.newBuilder();
        builder.addHeader("x-api-key", BuildConfig.DEBUG ? VisualApiService.DEV_API_KEY : VisualApiService.PROD_API_KEY);
        builder.addHeader("Content-Type", "application/json");
        return chain.proceed(builder.build());
    }
}
