package com.tenqube.visual_third;

import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;

public interface VisualService {

    /**
     * 약관 동의후 벌크 파싱 시작
     * @param custId 클립 사용자 아이디
     */
    void startBulkParsing(String custId) throws ParameterException, AuthException, SecurityException;

    /**
     * 비주얼 가계부 화면 호출
     */
    void startVisualWeb() throws AuthException;

    /**
     * 로그 확인을 위한 디버그 적용 함수
     * @param isDebug
     */
    void setDebugMode(boolean isDebug);


    /**
     * SDK초기화 함수 개발 전용
     */
    void initSDK();



}
