/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.receiver.AlarmReceiver;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualAlarmManager {
    public static final String TAG = VisualAlarmManager.class.getSimpleName();
    private static final int ALARM_SET = 0;
    private static final int ALARM_REPEAT = 1;
    private Context context;
    private static VisualAlarmManager mInstance = null;
    private AlarmManager alarmManager;
    private VisualRepository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualAlarmManager getInstance(Context ctx) {
        Class<VisualAlarmManager> clazz = VisualAlarmManager.class;
        synchronized (VisualAlarmManager.class) {
            if (mInstance == null) {
                mInstance = new VisualAlarmManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualAlarmManager(Context context) {
        this.context = context;
        this.alarmManager = (AlarmManager)context.getSystemService("alarm");
        this.repository = VisualRepository.getInstance(context);
    }

    public void setReportTest(String type, int second) {
        ArrayList<VisualNotification> notifications = this.repository.loadNotifications();
        for (VisualNotification notification : notifications) {
            if (!notification.getName().contains(type)) continue;
            this.cancelAlarm(notification);
            PendingIntent pIntent = this.createPendingIntent(notification);
            long alarmTime = System.currentTimeMillis() + (long)(second * 1000);
            if (Build.VERSION.SDK_INT >= 23) {
                this.alarmManager.setAndAllowWhileIdle(0, alarmTime, pIntent);
                continue;
            }
            this.alarmManager.set(0, alarmTime, pIntent);
        }
    }

    public void setAlarms() {
        ArrayList<VisualNotification> notifications = this.repository.loadNotifications();
        for (VisualNotification notification : notifications) {
            this.cancelAlarm(notification);
            if (!notification.isEnable()) continue;
            this.setAlarm(notification);
        }
    }

    private void setAlarm(VisualNotification notification) {
        PendingIntent pIntent = this.createPendingIntent(notification);
        long alarmTime = this.calculateAlarmTime(notification);
        if (Build.VERSION.SDK_INT >= 23) {
            this.alarmManager.setAndAllowWhileIdle(0, alarmTime, pIntent);
        } else {
            this.alarmManager.set(0, alarmTime, pIntent);
        }
    }

    private void cancelAlarm(VisualNotification notification) {
        PendingIntent pIntent = this.createPendingIntent(notification);
        this.alarmManager.cancel(pIntent);
    }

    private PendingIntent createPendingIntent(VisualNotification notification) {
        Intent intent = new Intent(this.context, AlarmReceiver.class);
        intent.setAction("ACTION_TENQUBE_NOTIFICATION");
        Bundle bundle = new Bundle();
        bundle.putSerializable("data", (Serializable)notification);
        intent.putExtra("bundle", bundle);
        LogUtil.LOGI((String)"ALARM", (String)("createPendingIntent" + intent.getBundleExtra("bundle")), (boolean)true);
        return PendingIntent.getBroadcast((Context)this.context, (int)notification.getId(), (Intent)intent, (int)0x8000000);
    }

    private long calculateAlarmTime(VisualNotification notification) {
        Calendar calendar = Calendar.getInstance();
        long currentTime = calendar.getTimeInMillis();
        int currentDay = calendar.get(5);
        int currentHour = calendar.get(11);
        calendar.set(12, 0);
        calendar.set(13, 0);
        int day = notification.getDay();
        int dayOfWeek = notification.getDayOfWeek();
        int hour = notification.getHour();
        switch (notification.getName()) {
            case "monthly": {
                if (day == currentDay) {
                    if (currentHour >= hour) {
                        calendar.add(2, 1);
                    }
                } else {
                    calendar.add(2, 1);
                }
                calendar.set(5, day);
                calendar.set(11, hour);
                break;
            }
            case "weekly_mon": 
            case "weekly_fri": {
                calendar.set(11, hour);
                calendar.set(7, dayOfWeek);
                if (currentTime < calendar.getTimeInMillis()) break;
                calendar.add(3, 1);
                break;
            }
            case "daily": {
                calendar.set(11, hour);
                if (currentTime < calendar.getTimeInMillis()) break;
                calendar.add(5, 1);
            }
        }
        LogUtil.LOGI((String)TAG, (String)("notification.getName()" + notification.getName()), (boolean)ParserService.mIsDebug);
        LogUtil.LOGI((String)TAG, (String)("Alarm Date: " + Utils.getStringDateAsYYYYMMddHHmmss(calendar)), (boolean)ParserService.mIsDebug);
        return calendar.getTimeInMillis();
    }
}

