package com.tenqube.visual_third.ui;

import android.app.Activity;

import com.tenqube.visual_third.manager.StatusManager;

public class BaseActivity extends Activity {

    boolean shouldShowLockScreen = false;
    public static boolean skipFlag = false;

    @Override
    protected void onUserLeaveHint() {
        shouldShowLockScreen = true;
        super.onUserLeaveHint();
    }

    @Override
    public void onResume() {
        super.onResume();
        overridePendingTransition(0, 0);
        if(skipFlag) {
            skipFlag = false;
            return;
        }
        if(shouldShowLockScreen) {
            shouldShowLockScreen = false;
            skipFlag = true;
            StatusManager.getInstance().onResume();
        }
    }


    @Override
    public void onPause() {
        super.onPause();
        overridePendingTransition(0, 0);
        if(skipFlag) {
            shouldShowLockScreen = false;
            skipFlag = false;
            return;
        }
        shouldShowLockScreen = true;
    }


}
