package com.tenqube.visual_third.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.os.BuildCompat;

import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;

import java.util.Calendar;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class AlarmReceiver extends BroadcastReceiver {

    protected static final String TAG = AlarmReceiver.class.getSimpleName();

    public static final String ACTION_TENQUBE_NOTIFICATION = "ACTION_TENQUBE_NOTIFICATION_IBK";
    @Override
    public void onReceive(final Context context, Intent intent) {

        final Context lContext = getContext(context);
        if(ACTION_TENQUBE_NOTIFICATION.equals(intent.getAction())) {
            try {

                Bundle bundle = intent.getBundleExtra("bundle");
                if (bundle != null) {

                    VisualNotification notification = (VisualNotification) bundle.getSerializable("data");
                    if(notification != null &&
                            notification.isEnable() &&
                            !"daily".equals(notification.getName()) &&
                            VisualAlarmManager.getInstance(lContext).isActiveNoti(notification.getId())) {

                        LOGI(TAG, "start Alarm", mIsDebug);

                        // 알림이 울린시점의 시간이 저녁인경우
                        if(shouldShow(notification))
                            VisualNotificationManager.getInstance(lContext).showNotification(notification);
                    } else {
                        LOGI(TAG, "notification == null", mIsDebug);
                    }
                } else {
                    LOGI(TAG, "bundle == null", mIsDebug);
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                VisualAlarmManager.getInstance(lContext).syncNotification();
                VisualAlarmManager.getInstance(lContext).setAlarms();
            }
        }
    }

    private boolean shouldShow(VisualNotification notification) {

        if(notification.isTest()) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int diff = hour - notification.getHour();

        LOGI(TAG, "hour" + hour, mIsDebug);
        LOGI(TAG, "diff" + diff, mIsDebug);
        LOGI(TAG, "Math.abs(hour - diff)" + Math.abs(diff), mIsDebug);

        return Math.abs(diff) < 3;
    }

    private Context getContext(Context context) {
        if (BuildCompat.isAtLeastN()) {
            return context.createDeviceProtectedStorageContext();
        } else {
            return context;
        }
    }
}
