package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.notNull;

public class AdRequest extends Request implements Serializable {

    public String unitId;

    public ColorOption container;

    public ColorOption button;

    @Override
    public void checkParams() throws ParameterException {

        notNull(unitId);

        if(container != null) {
            notNull(container.bgColor);
        }

        if(button != null) {
            notNull(button.bgColor);
            notNull(button.textColor);
        }
    }

    public class ColorOption implements Serializable {
        public String bgColor;
        public String textColor;
    }
}

