package com.tenqube.visual_third.manager;

import com.tenqube.visual_third.ui.OnFinishListener;
import com.tenqube.visual_third.ui.OnStatusListener;

public class StatusManager {

    private OnStatusListener statusListener;

    private OnFinishListener onFinishListener;

    private static StatusManager mInstance = null;

    private boolean stopVisual;

    public static StatusManager getInstance() {

        synchronized (StatusManager.class) {
            if (mInstance == null) {
                mInstance = new StatusManager();
            }
        }
        return mInstance;
    }

    private StatusManager() {
    }

    public void setStopVisual(boolean stopVisual) {
        this.stopVisual = stopVisual;
        finish();
    }

    private void finish() {
        if(onFinishListener != null) {
            stopVisual = false;
            onFinishListener.onFinish();
        }
    }

    public void setOnFinishListener(OnFinishListener onFinishListener) {
        this.onFinishListener = onFinishListener;
        if(stopVisual) {
            finish();
        }
    }

    public void setStatusListener(OnStatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public void onResume() {
        if(this.statusListener != null)
            this.statusListener.onResume();
    }


}
