package com.tenqube.visual_third;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.OnStatusListener;

public interface VisualService {

    /**
     * 처음 가입 무조건 실행 해야함
     * @param uid 사용자 uid
     */
    void signUp(@NonNull String uid, @NonNull OnResultListener onResultListener) throws ParameterException;

    void signOut(Callback callback);

    /**
     * 비주얼을 종료시킵니다.
     */
    void stopVisual();

    /**
     * visual activity 상태 관리를 위해 사용됩니다.
     * @param statusListener
     */
    void setStatusListener(@NonNull OnStatusListener statusListener);

    /**
     * 비주얼 가계부 화면 호출
     * 가입되지 않은 사용자 가입처리를 위해 파라미터 추가
     *
     * @param uid 사용자 uid 등록 되지 않은경우 signUp 호출
     * @param onResultListener 미등록시 등록 결과를 위한 콜백 함수
     */
    void startVisual(@NonNull Activity activity,
                     @NonNull String uid,
                     @Nullable String path,
                     @NonNull OnResultListener onResultListener) throws ParameterException;

    /**
     * 팝업 보여질지 여부를 확인 합니다.
     * @return 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    boolean isActiveTranPopup();

    /**
     * 팝업 호출 여부
     * @param isActive 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    void setTranPopup(boolean isActive);
    /**
     * 로그 확인을 위한 함수
     * @param isActive 로그 확인 여부
     */
    void setLogger(boolean isActive);

    /**
     * SDK초기화 함수 개발 전용
     */
    void initSDK();

    /**
     * SDK 사용 여부 판단 플레그
     * @param enabled true : 동작 / false : 동작 안함.
     */
    void setEnabled(boolean enabled);

    void settingNotification(int smallIcon, String channel, int color) throws ParameterException;

    void setMonthlyNoti(boolean isActive);

    boolean isActiveMonthlyNoti();

    void setWeeklyNoti(boolean isActive);

    boolean isActiveWeeklyNoti();

    void setDailyNoti(boolean isActive);

    boolean isActiveDailyNoti();

    void setReportTest(String type, int second);



}
