//package com.tenqube.visual_third;
//
//import android.Manifest;
//import android.app.Activity;
//import android.app.NotificationChannel;
//import android.app.NotificationManager;
//import android.content.Intent;
//import android.content.pm.PackageManager;
//import android.os.Build;
//import android.os.Bundle;
//import android.support.v4.app.ActivityCompat;
//import android.support.v4.content.ContextCompat;
//import android.text.TextUtils;
//import android.view.View;
//import android.widget.CompoundButton;
//import android.widget.Switch;
//import android.widget.Toast;
//
//import com.tenqube.visual_third.Constants;
//import com.tenqube.visual_third.VisualService;
//import com.tenqube.visual_third.VisualServiceImpl;
//import com.tenqube.visual_third.exception.ParameterException;
//import com.tenqube.visual_third.ui.OnResultListener;
//import com.tenqube.visual_third.ui.OnStatusListener;
//import com.tenqube.visual_third.ui.VisualWebActivity;
//
//import static com.tenqube.visual_third.manager.PrefManager.NOTI_CHANNEL;
//import static com.tenqube.visual_third.ui.VisualWebActivity.ARG_PATH;
//import static com.tenqube.visual_third.ui.VisualWebActivity.VISUAL_REQUEST_CODE;
//
//
//public class MainActivity extends Activity {
//
//    public static final String API_KEY = ""; //api 키정보
//    private VisualService visualService;// 비주얼 서비스 객체
//    private String visualPath = "";
//
//    @Override
//    protected void onCreate(Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_main_test);
//
//        try {
//            // visual service 생성
//            visualService = new VisualServiceImpl(this,
//                    API_KEY,// 발급 된 키정보
//                    BuildConfig.DEBUG ? Constants.PROD : Constants.PROD,
//                    BuildConfig.APPLICATION_ID); // 레이어 정보 상용 배포시 Constants.PROD
//
//            visualService.setStatusListener(new OnStatusListener() {
//                @Override
//                public void onResume() {
//
////                    Intent intent = new Intent(MainActivity.this, LockScreenActivity.class);
////                    startActivity(intent);
//                    Toast.makeText(getApplicationContext(), "onResume", Toast.LENGTH_LONG).show();
//                }
//
//            });
//
//            visualService.setLogger(true); // 로그 활성화 정보
//            visualService.settingNotification(R.drawable.ic_deposit_etc, NOTI_CHANNEL, 0);
//            // daily 알림 설정
//            Switch daily = findViewById(R.id.daily);
//            daily.setChecked(visualService.isActiveDailyNoti());
//            daily.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//                @Override
//                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                    visualService.setDailyNoti(isChecked); // 일간 알림 활성화 여부
//
//                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
//                        int importance = NotificationManager.IMPORTANCE_DEFAULT;
//                        NotificationChannel channel = new NotificationChannel(NOTI_CHANNEL,"ibk",
//                                importance);
//
//                        // Register the channel with the system; you can't change the importance
//                        // or other notification behaviors after this
//                        NotificationManager notificationManager = getSystemService(NotificationManager.class);
//                        if(notificationManager != null) notificationManager.createNotificationChannel(channel);
//                    }
//                    visualService.setReportTest("monthly", 5);
//                    // Create the NotificationChannel, but only on API 26+ because
//                    // the NotificationChannel class is new and not in the support library
//
//                }
//            });
//
//            // weekly 알림 설정
//            Switch weekly = findViewById(R.id.weekly);
//            weekly.setChecked(visualService.isActiveWeeklyNoti());
//
//            weekly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//                @Override
//                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                    visualService.setWeeklyNoti(isChecked);// 주간 알림 활성화 여부
//
//                }
//            });
//
//            // monthly 알림설정
//            Switch monthly = findViewById(R.id.monthly);
//            monthly.setChecked(visualService.isActiveMonthlyNoti());
//            monthly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//                @Override
//                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                    visualService.setMonthlyNoti(isChecked);// 월간 알림 활성화 여부
//                }
//            });
//
//            visualPath = getVisualPath();
//            if(!TextUtils.isEmpty(visualPath)) {
//                startVisual();
//            }
//
//        } catch (ParameterException e) {
//            e.printStackTrace();
//        }
//
//    }
//
//    @Override
//    protected void onUserLeaveHint() {
//        super.onUserLeaveHint();
//    }
//
//    /**
//     *
//     * @param view
//     */
//    public void onWeb(View view) {
//
//        startVisual();
//    }
//
//    @Override
//    public void onRequestPermissionsResult(int requestCode,
//                                           String permissions[], int[] grantResults) {
//        switch (requestCode) {
//            case 0: {
//                if (grantResults.length > 0
//                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
//                    startVisual();
//                }
//                return;
//            }
//        }
//    }
//
//    /**
//     * 비주얼 가계부 시작하기
//     */
//    private void startVisual() {
//
//
//        if (ContextCompat.checkSelfPermission(MainActivity.this,
//                Manifest.permission.READ_SMS)
//                != PackageManager.PERMISSION_GRANTED) {
//
//            // Should we show an explanation?
//            if (ActivityCompat.shouldShowRequestPermissionRationale(MainActivity.this,
//                    Manifest.permission.READ_SMS
//            )) {
//
//
//            } else {
//
//                ActivityCompat.requestPermissions(MainActivity.this,
//                        new String[]{Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS},
//                        0);
//
//            }
//        } else {
//            try {
//                // MainActivity.this 값을 통해 startActivityForResult로 호출합니다.
//                // IBK user 고유 아이디 정보를 추가해 주세요.
//                // getVisualPath() 함수를 통해 딥링크를 통해 들어온 값을 전달합니다.
//                visualService.startVisual(MainActivity.this, ":userUniqueId", visualPath,  new OnResultListener() {
//                    @Override
//                    public void onResult(int signUpResult, String msg) {
//
//                    }
//                });
//            } catch (ParameterException e) {
//                e.printStackTrace();
//            }
//        }
//
//    }
//
//    @Override
//    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
//        super.onActivityResult(requestCode, resultCode, data);
//
//        switch (requestCode) {
//
//            case VISUAL_REQUEST_CODE:
//                // 화면 종료시 해당 code로 콜백
//                break;
//        }
//    }
//
//    /**
//     * 딥링크를 통해 함수 가져오기
//     * @return 딥링크를 통해 전달받은 인텐트 정보(경로)
//     */
//    private String getVisualPath() {
//        Intent intent = getIntent();
//
//        if (intent != null && Intent.ACTION_VIEW.equals(intent.getAction())) {
//            String path = intent.getStringExtra(ARG_PATH);
//            intent.removeExtra(ARG_PATH);
//            return path;
//        }
//
//        return "";
//    }
//}
