package com.tenqube.visual_third.web;

import android.text.TextUtils;
import android.webkit.WebView;

import com.tenqube.visual_third.ui.VisualWebActivity;

import static com.tenqube.visual_third.util.Utils.toJson;

public class Base {

    final VisualWebActivity activity;
    final WebView webView;
    final VisualInterface.Error error;

    public Base(VisualWebActivity activity, WebView webView, VisualInterface.Error error) {
        this.activity = activity;
        this.webView = webView;
        this.error = error;
    }


    String getJs(String callback, String data) {
        if(!TextUtils.isEmpty(data)) data = "'" + data + "'";
        return "javascript:window." + callback + "(" + data + ");";
    }


    void callback(final String callback, final Object object) {

        try {
            webView.post(new Runnable() {
                @Override
                public void run() {
                    webView.loadUrl(getJs(callback, object == null ? "" : toJson(object)));
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    void callbackWithStr(final String callback, final String value) {

        try {
            webView.post(new Runnable() {
                @Override
                public void run() {
                    webView.loadUrl(getJs(callback, value));
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    void onError(String fucName, String msg) {
        if(error != null) error.onError(fucName, msg);
    }
}
