/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager.bulk;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.manager.bulk.BulkParsingManager;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.ui.VisualActivityFragment;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class BulkParsingManagerImpl
implements BulkParsingManager {
    public static final int REQUEST_SMS = 0;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    private final Fragment fragment;
    private BulkLoader bulkLoader;
    private ProgressDialog progressDialog;
    private Callback<Boolean> callback;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 11: {
                        Bundle bundle;
                        if (BulkParsingManagerImpl.this.progressDialog != null && (bundle = msg.getData()) != null) {
                            BulkParsingManagerImpl.this.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                        }
                        break;
                    }
                    case 12: {
                        try {
                            BulkParsingManagerImpl.this.showProgress();
                        }
                        catch (Exception e) {
                            BulkParsingManagerImpl.this.progressDialog = null;
                        }
                        break;
                    }
                    default: {
                        if (BulkParsingManagerImpl.this.progressDialog != null) {
                            BulkParsingManagerImpl.this.progressDialog.dismiss();
                        }
                        BulkParsingManagerImpl.this.callback.onComplete(true);
                    }
                }
            }
            catch (Exception e) {
                if (BulkParsingManagerImpl.this.progressDialog != null) {
                    BulkParsingManagerImpl.this.progressDialog.dismiss();
                }
                BulkParsingManagerImpl.this.callback.onComplete(false);
            }
            return false;
        }
    });

    public BulkParsingManagerImpl(Fragment fragment) {
        this.fragment = fragment;
    }

    @Override
    @AfterPermissionGranted(value=0)
    public void start(Callback<Boolean> callback) {
        this.callback = callback;
        String[] perms = new String[]{"android.permission.READ_SMS", "android.permission.RECEIVE_SMS"};
        if (PermissionUtil.hasPermissions(this.fragment.getContext(), perms)) {
            this.startParsing();
        } else {
            PermissionUtil.requestPermissions(this.fragment, 0, perms);
        }
    }

    private void startParsing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtil.LOGI((String)"VisualFlow", (String)"startBulk parsing", (boolean)ParserService.mIsDebug);
                    BulkParsingManagerImpl.this.bulkLoader = new BulkLoader(BulkParsingManagerImpl.this.fragment.getContext(), BulkParsingManagerImpl.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (BulkParsingManagerImpl.this.handler != null) {
                                    BulkParsingManagerImpl.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    LogUtil.LOGI((String)VisualActivityFragment.TAG, (String)"2. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                    BulkParsingManagerImpl.this.handler.sendEmptyMessage(12);
                    LogUtil.LOGI((String)VisualActivityFragment.TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                    BulkParsingManagerImpl.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    BulkParsingManagerImpl.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    @Override
    public void onPermissionGranted() {
        LogUtil.LOGI((String)"VisualFlow", (String)"onPermissionGranted", (boolean)ParserService.mIsDebug);
        this.startParsing();
    }

    @Override
    public void onPermissionsDenied() {
        this.callback.onComplete(false);
    }

    private void showProgress() {
        try {
            this.progressDialog = new ProgressDialog(this.fragment.getContext());
            this.progressDialog.setProgressStyle(1);
            this.progressDialog.setMessage((CharSequence)this.fragment.getString(R.string.progress_description));
            this.progressDialog.setCancelable(false);
            this.progressDialog.setCanceledOnTouchOutside(false);
            this.progressDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setProgressValue(int now, int total, int percent) {
        this.progressDialog.setProgress(percent);
    }
}

