/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.NotificationApp;
import java.util.ArrayList;

public class NotificationAppDao {
    private final Db db;

    public NotificationAppDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NotificationApp> findAll() {
        ArrayList<NotificationApp> results = new ArrayList<NotificationApp>();
        String query = QueryGenerator.notificationApp();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.NotificationAppTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    public void mergeAll(ArrayList<NotificationApp> apps) {
        try {
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<Integer> deletedIds = new ArrayList<Integer>();
            for (NotificationApp app : apps) {
                if (app.getEnabled() == 0) {
                    deletedIds.add(app.getId());
                    continue;
                }
                values.add(app.insertValues());
            }
            String insertQuery = "INSERT OR REPLACE INTO NOTIFICATION_APPS (_id,name,image,priority)VALUES" + TextUtils.join((CharSequence)",", values);
            this.db.runQuery(insertQuery);
            this.db.delete(" NOTIFICATION_APPS ", "_id IN (" + TextUtils.join((CharSequence)",", deletedIds) + ")", null);
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }
}

