package com.tenqube.visual_third.manager;

import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.model.api.VersionResponse;

import static com.tenqube.visual_third.Constants.ANALYSIS_VERSION;
import static com.tenqube.visual_third.Constants.CATEGORY_VERSION;
import static com.tenqube.visual_third.Constants.PKG_VERSION;
import static com.tenqube.visual_third.api.VisualApi.API_KEY;

public class ResourceManager {

    private final VisualApi visualApi;
    private final PrefManager prefManager;

    private static ResourceManager mInstance = null;

    public static ResourceManager getInstance(VisualApi visualApi, PrefManager prefManager) {

        synchronized (ResourceManager.class) {
            if (mInstance == null) {
                mInstance = new ResourceManager(visualApi, prefManager);
            }
        }
        return mInstance;
    }

    private ResourceManager(VisualApi visualApi, PrefManager prefManager) {
        this.visualApi = visualApi;
        this.prefManager = prefManager;
    }

    public void sync() {
        new Thread(new Runnable() {
            @Override
            public void run() {

                try {
                    String[] authInfos = visualApi.getAuthInfo();

                    VersionResponse versionResponse = visualApi.syncVersion(authInfos[API_KEY]);

                    syncCategory(authInfos, versionResponse);

                    syncAnalysis(authInfos, versionResponse);

                    syncNotificationApps(authInfos, versionResponse);

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }).start();

    }

    private void syncCategory(String[] authInfos, VersionResponse versionResponse) {
        int clientVersion = prefManager.loadIntValue(PrefManager.CATEGORY_VERSION, CATEGORY_VERSION);
        if(versionResponse != null && versionResponse.getCategory() > clientVersion) {
            visualApi.syncCategory(authInfos, clientVersion, versionResponse.getCategory());
        }
    }

    private void syncAnalysis(String[] authInfos, VersionResponse versionResponse) {
        int clientVersion = prefManager.loadIntValue(PrefManager.ANALYSIS_VERSION, ANALYSIS_VERSION);
        if(versionResponse != null && versionResponse.getAnalysis() > clientVersion) {
            visualApi.syncAnalysis(authInfos, clientVersion, versionResponse.getAnalysis());
        }
    }

    private void syncNotificationApps(String[] authInfos, VersionResponse versionResponse) {
        int clientVersion = prefManager.loadIntValue(PrefManager.PKG_VERSION, PKG_VERSION);
        if(versionResponse != null && versionResponse.getPkgVersion() > clientVersion) {
            visualApi.syncNotificationApps(authInfos, versionResponse.getPkgVersion());
        }
    }

}
