package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteException;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Advertisement;

import java.util.ArrayList;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class AdvertisementDao {

    private final Db db;

    public AdvertisementDao(Db db) {
        this.db = db;
    }

    public void loadAll() {
        LOGI("LOADALL", "AdvertisementDao loadAll", mIsDebug);
        String query = QueryGenerator.advertisement();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        LOGI("LOADALL", ReaderContract.AdvertisementTable.populateModel(c).toString(), mIsDebug);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }
    }

    public boolean isSatisfied(String query) {
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if (c != null) {
                if (c.moveToFirst()) {
                    return c.getInt(0) == 1;
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }

        return false;
    }

    public Advertisement loadAd(int id) {
        String query = QueryGenerator.advertisement(id);
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        return ReaderContract.AdvertisementTable.populateModel(c);
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }
        return null;
    }

    public ArrayList<Advertisement> loadAds() {
        String query = QueryGenerator.advertisement();
        ArrayList<Advertisement> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.AdvertisementTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }


    public void merge(Advertisement advertisement) {

        try {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.AdvertisementTable.COLUMN_ID, advertisement.getId());
            values.put(ReaderContract.AdvertisementTable.COLUMN_TITLE, advertisement.getTitle());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LABEL, advertisement.getLabel());
            values.put(ReaderContract.AdvertisementTable.COLUMN_CONTENT, advertisement.getContent());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LINKTO, advertisement.getLinkTo());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LINKTO_TYPE, advertisement.getLinkToType());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LINKTO_STR, advertisement.getLinkToStr());

            values.put(ReaderContract.AdvertisementTable.COLUMN_IMAGE, advertisement.getImage());
            values.put(ReaderContract.AdvertisementTable.COLUMN_ICON_IMAGE, advertisement.getImage());

            values.put(ReaderContract.AdvertisementTable.COLUMN_PRIORITY, advertisement.getPriority());
            values.put(ReaderContract.AdvertisementTable.COLUMN_QUERY, advertisement.getQuery());
            db.insertOnReplace(ReaderContract.AdvertisementTable.TABLE_NAME, values);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
