/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.tenqube.visual_third.core.FusedLocationManager;
import com.tenqube.visual_third.core.VisualApi;
import com.tenqube.visual_third.model.Company;
import com.tenqube.visual_third.model.TranCompany;
import com.tenqube.visual_third.model.TransactionPopupInfo;
import com.tenqube.visual_third.ui.TransactionPopupActivity;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.LogUtil;

class OneLoader {
    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private Context mContext;
    private final FusedLocationManager fusedLocationManager;
    private ParserService parserService;
    private int mServerCnt = 0;
    private VisualApi api;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            Bundle bundle;
            if (msg.what == 200 && (bundle = msg.getData()) != null) {
                TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo((Transaction)bundle.getSerializable("transaction"), (Company)bundle.getSerializable("company"));
                TransactionPopupActivity.startActivity(OneLoader.this.mContext, transactionPopupInfo);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneLoader getInstance(Context context) {
        Class<OneLoader> clazz = OneLoader.class;
        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private OneLoader(Context context) {
        this.mContext = context;
        this.fusedLocationManager = FusedLocationManager.getInstance(context);
        this.parserService = ParserService.getInstance((Context)context);
        this.api = VisualApi.getInstance(context);
    }

    public synchronized void doParsing(final SMS sms) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogUtil.LOGI((String)TAG, (String)("doParsing" + sms.toString()), (boolean)true);
                OneLoader.this.fusedLocationManager.loadLastLocation();
                ParserResult parserResult = OneLoader.this.parserService.parse(sms);
                if (parserResult.resultCode != 1 && "com.samsung.android.spay".equals(sms.sender)) {
                    sms.fullSms = sms.title;
                    parserResult = OneLoader.this.parserService.parse(sms);
                }
                LogUtil.LOGI((String)TAG, (String)("parserResult" + parserResult.resultCode + ResultCode.stringValueOf((Integer)parserResult.resultCode)), (boolean)true);
                switch (parserResult.resultCode) {
                    case -4: {
                        OneLoader.this.syncParsingRule();
                        break;
                    }
                    case -6: {
                        if (!Utils.shouldParsing(sms.fullSms)) break;
                        OneLoader.this.syncParsingRuleAndNoSender();
                        break;
                    }
                    case -5: {
                        break;
                    }
                    case 1: {
                        OneLoader.this.parsedSMS(parserResult.transactions);
                    }
                }
            }
        }).start();
    }

    private void syncParsingRuleAndNoSender() {
        ++this.mServerCnt;
        if (this.mServerCnt == 5) {
            this.mServerCnt = 0;
            this.syncParsingRule();
        }
    }

    private void parsedSMS(ArrayList<Transaction> transactions) {
        try {
            Transaction currentTran = this.popCurrentTran(transactions);
            if (currentTran != null) {
                this.addLocationInfo(currentTran);
            }
            if (!transactions.isEmpty()) {
                this.api.searchCompany(transactions, new Callback<TranCompany>(){

                    public void onResponse(Call<TranCompany> call, Response<TranCompany> response) {
                    }

                    public void onFailure(Call<TranCompany> call, Throwable t) {
                    }
                });
            }
            TranCompany tranCompany = this.api.searchCompany(currentTran);
            if (currentTran != null && currentTran.isDuplicate == 0) {
                this.checkCurrentTranInfo(tranCompany, currentTran);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Transaction popCurrentTran(ArrayList<Transaction> transactions) {
        int index = -1;
        for (int i = 0; i < transactions.size(); ++i) {
            Transaction transaction = transactions.get(i);
            if (!transaction.isCurrentTran) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Transaction transaction = transactions.get(index);
            transactions.remove(index);
            return transaction;
        }
        return null;
    }

    private void addLocationInfo(Transaction currentTran) {
        Location location = this.fusedLocationManager.getLocation();
        if (location != null) {
            currentTran.spentLatitude = location.getLatitude();
            currentTran.spentLongitude = location.getLongitude();
        } else {
            currentTran.spentLatitude = -1.0;
            currentTran.spentLongitude = -1.0;
        }
    }

    private void checkCurrentTranInfo(TranCompany tranCompany, Transaction currentTran) {
        boolean isMatched = false;
        if (tranCompany != null) {
            for (Company company : tranCompany.getCompanys()) {
                if (company.getIdentifier() != currentTran.identifier) continue;
                TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo(currentTran, company);
                TransactionPopupActivity.startActivity(this.mContext, transactionPopupInfo);
                isMatched = true;
                break;
            }
            if (!isMatched && ParserService.mIsDebug && !tranCompany.getCompanys().isEmpty()) {
                TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo(currentTran, tranCompany.getCompanys().get(0));
                TransactionPopupActivity.startActivity(this.mContext, transactionPopupInfo);
            }
        }
    }

    private void syncParsingRule() {
        this.parserService.syncParsingRule(this.api.syncParsingRule());
    }
}

