package com.tenqube.visual_third.model.analysis;

import java.io.Serializable;

public class TopN implements Serializable {

    private int order;
    private String title;
    private String amount;
    private String percent;
    private String cnt;

    public TopN(String title, String amount, String percent) {
        this.title = title;
        this.amount = amount;
        this.percent = percent;
    }

    public TopN(String title, String cnt) {
        this.title = title;
        this.cnt = cnt;
    }

    public String getTitle() {
        return title;
    }

    public String getAmount() {
        return amount;
    }

    public String getPercent() {
        return percent;
    }

    public int getOrder() {
        return order;
    }

    public String getCnt() {
        return cnt;
    }

//    주로 지출한 항목은
//
//1위 외식 (32%),
//2위 카페/간식 (22%),
//3위 인터넷쇼핑 (21%) 입니
    public String getLargeValue(int order) {
        this.order = order;
        return order + "위 " + title + "(" +getPercent() +")";
    }

    //    1위 아울렛 (31.2만원, 32%)
//2위 의류 (32.1만원, 32%)

    public String getMidValue(int order) {
        this.order = order;
        return order + "위 " + title + "(" + getAmount() + ", " + getPercent() +")";
    }

    public String getCntValue() {
        return title + " " + cnt;
    }
}
