/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.SystemClock;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.js.ConfirmBoxRequest;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.NewViewRequest;
import com.tenqube.visual_third.model.js.PageInfoRequest;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;

public class UiImpl
extends Base
implements VisualInterface.UI,
BottomDialog.OnBottomListener {
    private String callbackSelectOrderBy;
    private final BottomDialog bottomDialog;
    private long mLastClickTime;
    private AppExecutors appExecutors;

    public UiImpl(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error, BottomDialog bottomDialog) {
        super(context, contractor, webView, error);
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
        this.appExecutors = new AppExecutors();
    }

    @Override
    @JavascriptInterface
    public void openConfirmBox(final String params) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "openConfirmBox";
                try {
                    final ConfirmBoxRequest confirmBoxRequest = Utils.fromJson(params, ConfirmBoxRequest.class);
                    confirmBoxRequest.checkParams();
                    AlertDialog.Builder builder = new AlertDialog.Builder(UiImpl.this.context);
                    builder.setMessage((CharSequence)confirmBoxRequest.getMessage());
                    builder.setNegativeButton((CharSequence)confirmBoxRequest.getData().get(0).getButtonText(), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            UiImpl.this.callback(confirmBoxRequest.getData().get(0).getCallbackJS(), null);
                        }
                    });
                    builder.setPositiveButton((CharSequence)confirmBoxRequest.getData().get(1).getButtonText(), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            UiImpl.this.callback(confirmBoxRequest.getData().get(1).getCallbackJS(), null);
                        }
                    });
                    AlertDialog alertDialog = builder.create();
                    alertDialog.show();
                }
                catch (ParameterException e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void openSelectBox(final String params) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "openSelectBox";
                try {
                    SelectBoxRequest selectBoxRequest = Utils.fromJson(params, SelectBoxRequest.class);
                    selectBoxRequest.checkParams();
                    UiImpl.this.callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();
                    if (UiImpl.this.bottomDialog != null) {
                        UiImpl.this.bottomDialog.showBottomDialog(selectBoxRequest);
                    }
                }
                catch (ParameterException e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    public void onItemSelected(final SelectBoxInfo selectBoxInfo) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                if (UiImpl.this.bottomDialog != null) {
                    UiImpl.this.bottomDialog.dismiss();
                }
                UiImpl.this.callback(UiImpl.this.callbackSelectOrderBy, selectBoxInfo);
            }
        });
    }

    @Override
    @JavascriptInterface
    public void openNewView(final String params) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "openNewView";
                try {
                    if (SystemClock.elapsedRealtime() - UiImpl.this.mLastClickTime < 1000L) {
                        return;
                    }
                    UiImpl.this.mLastClickTime = SystemClock.elapsedRealtime();
                    NewViewRequest newViewInfo = Utils.fromJson(params, NewViewRequest.class);
                    newViewInfo.checkParams();
                    switch (newViewInfo.getViewType()) {
                        case "external": {
                            Intent i = new Intent("android.intent.action.VIEW");
                            i.setData(Uri.parse((String)newViewInfo.getUrl()));
                            UiImpl.this.context.startActivity(i);
                            break;
                        }
                        case "internal": {
                            UiImpl.this.contractor.startPopup(newViewInfo.getUrl());
                            break;
                        }
                        case "google": {
                            GoOpenMarketUtil.openOnGooglePlayMarket(UiImpl.this.context, newViewInfo.getUrl());
                            break;
                        }
                    }
                }
                catch (ParameterException e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void finish(final String path) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "finish";
                try {
                    if (UiImpl.this.contractor != null) {
                        UiImpl.this.contractor.onFinish(path);
                    }
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void showSnackBar(final String msg) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Snackbar.make((View)UiImpl.this.webView, (CharSequence)msg, (int)-1).show();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void showToast(final String msg) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Toast.makeText((Context)UiImpl.this.context, (CharSequence)msg, (int)0).show();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void onPageLoaded(final String params) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PageInfoRequest page = Utils.fromJson(params, PageInfoRequest.class);
                    page.checkParams();
                    if (UiImpl.this.contractor != null) {
                        UiImpl.this.contractor.onPageLoaded();
                    }
                }
                catch (ParameterException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void onScrollChanged(boolean shouldShow) {
    }

    @Override
    @JavascriptInterface
    public void onFinish() {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "onFinish";
                try {
                    UiImpl.this.callback("onFinish", null);
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void showDatePicker(final String params) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "showMonthPicker";
                try {
                    DateRequest dateRequest = Utils.fromJson(params, DateRequest.class);
                    dateRequest.checkParams();
                    if (UiImpl.this.contractor != null) {
                        UiImpl.this.contractor.showDatePicker(dateRequest);
                    }
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void showTimePicker(final String params) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "showTimePicker";
                try {
                    TimeRequest timeRequest = Utils.fromJson(params, TimeRequest.class);
                    timeRequest.checkParams();
                    if (UiImpl.this.contractor != null) {
                        UiImpl.this.contractor.showTimePicker(timeRequest);
                    }
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void reload() {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "reload";
                try {
                    if (UiImpl.this.contractor != null) {
                        UiImpl.this.contractor.reload();
                    }
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void retry() {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "retry";
                try {
                    if (UiImpl.this.contractor != null) {
                        UiImpl.this.contractor.retry();
                    }
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    @JavascriptInterface
    public void setRefreshEnabled(final boolean enabled) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                String funcName = "setRefreshEnabled";
                try {
                    if (UiImpl.this.contractor != null) {
                        UiImpl.this.contractor.setRefreshEnabled(enabled);
                    }
                }
                catch (Exception e) {
                    UiImpl.this.onError(funcName, e.toString());
                }
            }
        });
    }

    @Override
    public void onCalendar(final String date, final String callback) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                UiImpl.this.callbackWithStr(callback, date);
            }
        });
    }
}

